"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.CspCustomAssetsExtension = void 0;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/fleet-plugin/public");
var _i18n = require("@kbn/i18n");
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _constants = require("../../../common/constants");
var _use_kibana = require("../../common/hooks/use_kibana");
var _constants2 = require("../../common/navigation/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/components/fleet_extensions/custom_assets_extension.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SECURITY_APP_NAME = 'securitySolutionUI';
const CspCustomAssetsExtension = () => {
  const {
    application
  } = (0, _use_kibana.useKibana)().services;
  const integration = (0, _reactRouterDom.useParams)().integration;
  const viewsCNVM = [{
    name: _constants2.cloudPosturePages.vulnerability_dashboard.name,
    url: application.getUrlForApp(SECURITY_APP_NAME, {
      path: _constants2.cloudPosturePages.vulnerability_dashboard.path
    }),
    description: _i18n.i18n.translate('xpack.csp.createPackagePolicy.customAssetsTab.vulnerabilityDashboardViewLabel', {
      defaultMessage: 'View CNVM Dashboard'
    })
  }, {
    name: _constants2.cloudPosturePages.findings.name,
    url: application.getUrlForApp(SECURITY_APP_NAME, {
      path: _constants2.cloudPosturePages.findings.path + '/vulnerabilities'
    }),
    description: _i18n.i18n.translate('xpack.csp.createPackagePolicy.customAssetsTab.vulnerabilityFindingsViewLabel', {
      defaultMessage: 'View Vulnerability Findings '
    })
  }];
  const views = [{
    name: _constants2.cloudPosturePages.dashboard.name,
    url: application.getUrlForApp(SECURITY_APP_NAME, {
      path: _constants2.cloudPosturePages.dashboard.path
    }),
    description: _i18n.i18n.translate('xpack.csp.createPackagePolicy.customAssetsTab.dashboardViewLabel', {
      defaultMessage: 'View CSP Dashboard'
    })
  }, {
    name: _constants2.cloudPosturePages.findings.name,
    url: application.getUrlForApp(SECURITY_APP_NAME, {
      path: _constants2.cloudPosturePages.findings.path
    }),
    description: _i18n.i18n.translate('xpack.csp.createPackagePolicy.customAssetsTab.findingsViewLabel', {
      defaultMessage: 'View CSP Findings '
    })
  }, {
    name: _cloudSecurityPosture.benchmarksNavigation.rules.name,
    url: application.getUrlForApp(SECURITY_APP_NAME, {
      path: _constants2.cloudPosturePages.benchmarks.path
    }),
    description: _i18n.i18n.translate('xpack.csp.createPackagePolicy.customAssetsTab.rulesViewLabel', {
      defaultMessage: 'View CSP Rules '
    })
  }];
  if (!integration) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_public.CustomAssetsAccordion, {
      views: views,
      initialIsOpen: true,
      title: _i18n.i18n.translate('xpack.csp.createPackagePolicy.customAssetsTab.cloudPostureTitleLabel', {
        defaultMessage: 'Cloud Posture '
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_public.CustomAssetsAccordion, {
      views: viewsCNVM,
      initialIsOpen: true,
      title: _i18n.i18n.translate('xpack.csp.createPackagePolicy.customAssetsTab.cloudNativeVulnerabilityManagementTitleLabel', {
        defaultMessage: 'Cloud Native Vulnerability Management '
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 9
      }
    }));
  }
  if (integration === _constants.VULN_MGMT_POLICY_TEMPLATE) {
    return /*#__PURE__*/_react.default.createElement(_public.CustomAssetsAccordion, {
      views: viewsCNVM,
      initialIsOpen: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_public.CustomAssetsAccordion, {
    views: views,
    initialIsOpen: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 10
    }
  });
};
// eslint-disable-next-line import/no-default-export
exports.default = exports.CspCustomAssetsExtension = CspCustomAssetsExtension;