"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateMappings = void 0;
var _server = require("@kbn/actions-plugin/server");
var _api = require("../../../common/types/api");
var _runtime_types = require("../../common/runtime_types");
var _error = require("../../common/error");
var _connectors = require("../../connectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const updateMappings = async ({
  connector,
  mappingId,
  refresh
}, clientArgs) => {
  const {
    unsecuredSavedObjectsClient,
    services: {
      connectorMappingsService
    },
    logger
  } = clientArgs;
  try {
    var _casesConnectors$get$, _casesConnectors$get;
    const mappings = (_casesConnectors$get$ = (_casesConnectors$get = _connectors.casesConnectors.get(connector.type)) === null || _casesConnectors$get === void 0 ? void 0 : _casesConnectors$get.getMapping()) !== null && _casesConnectors$get$ !== void 0 ? _casesConnectors$get$ : [];
    const theMapping = await connectorMappingsService.update({
      unsecuredSavedObjectsClient,
      mappingId,
      attributes: {
        mappings
      },
      references: [{
        type: _server.ACTION_SAVED_OBJECT_TYPE,
        name: `associated-${_server.ACTION_SAVED_OBJECT_TYPE}`,
        id: connector.id
      }],
      refresh
    });
    const res = {
      id: theMapping.id,
      version: theMapping.version,
      mappings: theMapping.attributes.mappings
    };
    return (0, _runtime_types.decodeOrThrow)(_api.ConnectorMappingResponseRt)(res);
  } catch (error) {
    throw (0, _error.createCaseError)({
      message: `Failed to create mapping connector id: ${connector.id} type: ${connector.type}: ${error}`,
      error,
      logger
    });
  }
};
exports.updateMappings = updateMappings;