"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBulkPostObservables = void 0;
var _reactQuery = require("@tanstack/react-query");
var _constants = require("../../common/constants");
var _api = require("./api");
var _translations = _interopRequireWildcard(require("./translations"));
var i18n = _translations;
var _use_cases_toast = require("../common/use_cases_toast");
var _constants2 = require("./constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useBulkPostObservables = () => {
  const {
    showErrorToast,
    showInfoToast
  } = (0, _use_cases_toast.useCasesToast)();
  return (0, _reactQuery.useMutation)(request => {
    return (0, _api.bulkPostObservables)(request);
  }, {
    mutationKey: _constants2.casesMutationsKeys.bulkPostObservables,
    onError: error => {
      showErrorToast(error, {
        title: i18n.ERROR_TITLE
      });
    },
    onSuccess: response => {
      if (response.observables.length >= _constants.MAX_OBSERVABLES_PER_CASE) {
        showInfoToast(i18n.OBSERVABLE_BULK_CREATED, (0, _translations.OBSERVABLE_MAX_REACHED)(_constants.MAX_OBSERVABLES_PER_CASE));
      }
    }
  });
};
exports.useBulkPostObservables = useBulkPostObservables;