"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetSupportedActionConnectors = useGetSupportedActionConnectors;
var _reactQuery = require("@tanstack/react-query");
var _api = require("./api");
var _kibana = require("../../common/lib/kibana");
var i18n = _interopRequireWildcard(require("./translations"));
var _constants = require("../constants");
var _use_cases_context = require("../../components/cases_context/use_cases_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useGetSupportedActionConnectors() {
  const toasts = (0, _kibana.useToasts)();
  const {
    actions
  } = (0, _kibana.useApplicationCapabilities)();
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  return (0, _reactQuery.useQuery)(_constants.casesQueriesKeys.connectorsList(), async ({
    signal
  }) => {
    if (!actions.read || !permissions.connectors) {
      return [];
    }
    return (0, _api.getSupportedActionConnectors)({
      signal
    });
  }, {
    staleTime: 60 * 1000,
    // one minute
    onError: error => {
      if (error.name !== 'AbortError') {
        toasts.addError(error.body && error.body.message ? new Error(error.body.message) : error, {
          title: i18n.ERROR_TITLE
        });
      }
    }
  });
}