"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getShapeComponent = exports.createShape = void 0;
exports.getShapeContentElement = getShapeContentElement;
exports.getViewBox = getViewBox;
exports.viewBoxToString = viewBoxToString;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _types = require("./types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/shape_drawer/shape_factory.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function viewBoxToString(viewBox) {
  if (!viewBox) {
    return;
  }
  return `${viewBox === null || viewBox === void 0 ? void 0 : viewBox.minX} ${viewBox === null || viewBox === void 0 ? void 0 : viewBox.minY} ${viewBox === null || viewBox === void 0 ? void 0 : viewBox.width} ${viewBox === null || viewBox === void 0 ? void 0 : viewBox.height}`;
}
function getMinxAndWidth(viewBoxParams, {
  borderOffset,
  width
}) {
  let {
    minX,
    width: shapeWidth
  } = viewBoxParams;
  if (width) {
    const xOffset = shapeWidth / width * borderOffset;
    minX -= xOffset;
    shapeWidth += xOffset * 2;
  } else {
    shapeWidth = 0;
  }
  return [minX, shapeWidth];
}
function getMinyAndHeight(viewBoxParams, {
  borderOffset,
  height
}) {
  let {
    minY,
    height: shapeHeight
  } = viewBoxParams;
  if (height) {
    const yOffset = shapeHeight / height * borderOffset;
    minY -= yOffset;
    shapeHeight += yOffset * 2;
  } else {
    shapeHeight = 0;
  }
  return [minY, shapeHeight];
}
function getViewBox(viewBoxParams, parentNodeParams) {
  const [minX, width] = getMinxAndWidth(viewBoxParams, parentNodeParams);
  const [minY, height] = getMinyAndHeight(viewBoxParams, parentNodeParams);
  return {
    minX,
    minY,
    width,
    height
  };
}
const getShapeComponent = svgParams => function Shape({
  shapeAttributes,
  shapeContentAttributes,
  children,
  textAttributes
}) {
  const {
    viewBox: initialViewBox,
    shapeProps: defaultShapeContentAttributes,
    textAttributes: defaultTextAttributes,
    shapeType
  } = svgParams;
  const viewBox = shapeAttributes !== null && shapeAttributes !== void 0 && shapeAttributes.viewBox ? viewBoxToString(shapeAttributes === null || shapeAttributes === void 0 ? void 0 : shapeAttributes.viewBox) : viewBoxToString(initialViewBox);
  const SvgContentElement = getShapeContentElement(shapeType);
  const TextElement = textAttributes ? /*#__PURE__*/_react.default.forwardRef((props, ref) => /*#__PURE__*/_react.default.createElement("text", (0, _extends2.default)({}, props, {
    ref: ref,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 58
    }
  }))) : null;
  return /*#__PURE__*/_react.default.createElement("svg", (0, _extends2.default)({
    xmlns: "http://www.w3.org/2000/svg"
  }, shapeAttributes || {}, {
    viewBox,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(SvgContentElement, (0, _extends2.default)({}, defaultShapeContentAttributes, shapeContentAttributes || {}, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 9
    }
  })), children, TextElement && /*#__PURE__*/_react.default.createElement(TextElement, (0, _extends2.default)({}, defaultTextAttributes || {}, textAttributes || {}, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 11
    }
  }), textAttributes === null || textAttributes === void 0 ? void 0 : textAttributes.textContent));
};
exports.getShapeComponent = getShapeComponent;
function getShapeContentElement(type) {
  switch (type) {
    case _types.SvgElementTypes.circle:
      return /*#__PURE__*/_react.default.forwardRef((props, ref) => /*#__PURE__*/_react.default.createElement("circle", (0, _extends2.default)({}, props, {
        ref: ref,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 102,
          columnNumber: 9
        }
      })));
    case _types.SvgElementTypes.rect:
      return /*#__PURE__*/_react.default.forwardRef((props, ref) => /*#__PURE__*/_react.default.createElement("rect", (0, _extends2.default)({}, props, {
        ref: ref,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 105,
          columnNumber: 70
        }
      })));
    case _types.SvgElementTypes.path:
      return /*#__PURE__*/_react.default.forwardRef((props, ref) => /*#__PURE__*/_react.default.createElement("path", (0, _extends2.default)({}, props, {
        ref: ref,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 107,
          columnNumber: 70
        }
      })));
    default:
      return /*#__PURE__*/_react.default.forwardRef((props, ref) => /*#__PURE__*/_react.default.createElement("polygon", (0, _extends2.default)({}, props, {
        ref: ref,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 110,
          columnNumber: 9
        }
      })));
  }
}
const createShape = props => {
  return {
    Component: getShapeComponent(props),
    data: props
  };
};
exports.createShape = createShape;