"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isGenerationErrorAttributes = isGenerationErrorAttributes;
exports.isGenerationErrorBody = isGenerationErrorBody;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Errors raised by the generation process should provide information through this interface.

function isGenerationErrorBody(obj) {
  return typeof obj === 'object' && obj !== null && 'message' in obj && typeof obj.message === 'string' && 'attributes' in obj && obj.attributes !== undefined && isGenerationErrorAttributes(obj.attributes);
}
function isGenerationErrorAttributes(obj) {
  return typeof obj === 'object' && obj !== null && 'errorCode' in obj && typeof obj.errorCode === 'string' && (!('underlyingMessages' in obj) || Array.isArray(obj.underlyingMessages));
}