"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bulkCreateApmSourceMaps = bulkCreateApmSourceMaps;
var _server = require("@kbn/apm-sources-access-plugin/server");
var _source_maps = require("../fleet/source_maps");
var _sourcemap_utils = require("./sourcemap_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function bulkCreateApmSourceMaps({
  artifacts,
  internalESClient
}) {
  const docs = await Promise.all(artifacts.map(async artifact => {
    const {
      serviceName,
      serviceVersion,
      bundleFilepath,
      sourceMap
    } = await (0, _source_maps.getUnzippedArtifactBody)(artifact.body);
    const {
      contentEncoded,
      contentHash
    } = await (0, _sourcemap_utils.getEncodedContent)(sourceMap);
    return {
      fleet_id: artifact.id,
      created: artifact.created,
      content: contentEncoded,
      content_sha256: contentHash,
      file: {
        path: bundleFilepath
      },
      service: {
        name: serviceName,
        version: serviceVersion
      }
    };
  }));
  return internalESClient.bulk({
    body: docs.flatMap(doc => {
      const id = (0, _sourcemap_utils.getSourceMapId)({
        serviceName: doc.service.name,
        serviceVersion: doc.service.version,
        bundleFilepath: doc.file.path
      });
      return [{
        create: {
          _index: _server.APM_SOURCE_MAP_INDEX,
          _id: id
        }
      }, doc];
    })
  });
}