"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchDurationFieldCandidates = fetchDurationFieldCandidates;
var _fieldTypes = require("@kbn/field-types");
var _server = require("@kbn/observability-plugin/server");
var _constants = require("../../../../common/correlations/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SUPPORTED_ES_FIELD_TYPES = [_fieldTypes.ES_FIELD_TYPES.KEYWORD, _fieldTypes.ES_FIELD_TYPES.IP, _fieldTypes.ES_FIELD_TYPES.BOOLEAN];
async function fetchDurationFieldCandidates({
  apmEventClient,
  eventType,
  start,
  end
}) {
  // Get all supported fields
  const respMapping = await apmEventClient.fieldCaps('get_field_caps', {
    apm: {
      events: [eventType]
    },
    fields: '*',
    // We exclude metadata and parent fields as they are not useful for correlations.
    // There's an issue in ES (https://github.com/elastic/elasticsearch/issues/109797)
    // that describes why we need to add -parent in addition to the types option.
    filters: '-metadata,-parent',
    include_empty_fields: false,
    index_filter: (0, _server.rangeQuery)(start, end)[0],
    types: SUPPORTED_ES_FIELD_TYPES
  });
  return {
    fieldCandidates: Object.keys(respMapping.fields).filter(fieldName => {
      return !_constants.FIELDS_TO_EXCLUDE_AS_CANDIDATE.has(fieldName) && !_constants.FIELD_PREFIX_TO_EXCLUDE_AS_CANDIDATE.some(prefix => fieldName.startsWith(prefix));
    })
  };
}