"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLogRateAnalysisForAlert = getLogRateAnalysisForAlert;
var _fetch_log_rate_analysis_for_alert = require("@kbn/aiops-log-rate-analysis/queries/fetch_log_rate_analysis_for_alert");
var _apm = require("../../../../common/es_fields/apm");
var _get_should_match_or_not_exist_filter = require("../utils/get_should_match_or_not_exist_filter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Runs log rate analysis data on an index given some alert metadata.
 */
async function getLogRateAnalysisForAlert({
  esClient,
  logSourcesService,
  arguments: args
}) {
  const index = await logSourcesService.getFlattenedLogSources();
  const keyValueFilters = (0, _get_should_match_or_not_exist_filter.getShouldMatchOrNotExistFilter)(Object.entries(args.entities).map(([key, value]) => ({
    field: key,
    value
  })));
  const searchQuery = {
    bool: {
      must_not: [
      // exclude APM errors
      {
        term: {
          [_apm.PROCESSOR_EVENT]: 'error'
        }
      }],
      filter: [...keyValueFilters]
    }
  };
  return (0, _fetch_log_rate_analysis_for_alert.fetchLogRateAnalysisForAlert)({
    esClient,
    arguments: {
      index,
      alertStartedAt: args.alertStartedAt,
      alertRuleParameterTimeSize: args.alertRuleParameterTimeSize,
      alertRuleParameterTimeUnit: args.alertRuleParameterTimeUnit,
      searchQuery
    }
  });
}