"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.alertsChartPreviewRouteRepository = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _ioTsUtils = require("@kbn/io-ts-utils");
var _get_transaction_duration_chart_preview = require("./rule_types/transaction_duration/get_transaction_duration_chart_preview");
var _get_error_count_chart_preview = require("./rule_types/error_count/get_error_count_chart_preview");
var _get_transaction_error_rate_chart_preview = require("./rule_types/transaction_error_rate/get_transaction_error_rate_chart_preview");
var _create_apm_server_route = require("../apm_routes/create_apm_server_route");
var _default_api_types = require("../default_api_types");
var _apm_rule_types = require("../../../common/rules/apm_rule_types");
var _get_apm_event_client = require("../../lib/helpers/get_apm_event_client");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const searchConfigurationRt = t.type({
  query: t.type({
    query: t.union([t.string, t.record(t.string, t.any)]),
    language: t.string
  })
});
const alertParamsRt = t.intersection([t.partial({
  aggregationType: t.union([t.literal(_apm_rule_types.AggregationType.Avg), t.literal(_apm_rule_types.AggregationType.P95), t.literal(_apm_rule_types.AggregationType.P99)]),
  serviceName: t.string,
  errorGroupingKey: t.string,
  transactionType: t.string,
  transactionName: t.string
}), _default_api_types.environmentRt, _default_api_types.rangeRt, t.type({
  interval: t.string
}), t.partial({
  groupBy: t.array(t.string),
  searchConfiguration: _ioTsUtils.jsonRt.pipe(searchConfigurationRt)
})]);
const transactionErrorRateChartPreview = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/rule_types/transaction_error_rate/chart_preview',
  params: t.type({
    query: alertParamsRt
  }),
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params,
      config
    } = resources;
    const {
      _inspect,
      ...alertParams
    } = params.query;
    const errorRateChartPreview = await (0, _get_transaction_error_rate_chart_preview.getTransactionErrorRateChartPreview)({
      config,
      apmEventClient,
      alertParams
    });
    return {
      errorRateChartPreview
    };
  }
});
const transactionErrorCountChartPreview = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/rule_types/error_count/chart_preview',
  params: t.type({
    query: alertParamsRt
  }),
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params
    } = resources;
    const {
      _inspect,
      ...alertParams
    } = params.query;
    const errorCountChartPreview = await (0, _get_error_count_chart_preview.getTransactionErrorCountChartPreview)({
      apmEventClient,
      alertParams
    });
    return {
      errorCountChartPreview
    };
  }
});
const transactionDurationChartPreview = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/rule_types/transaction_duration/chart_preview',
  params: t.type({
    query: alertParamsRt
  }),
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params,
      config
    } = resources;
    const {
      _inspect,
      ...alertParams
    } = params.query;
    const latencyChartPreview = await (0, _get_transaction_duration_chart_preview.getTransactionDurationChartPreview)({
      alertParams,
      config,
      apmEventClient
    });
    return {
      latencyChartPreview
    };
  }
});
const alertsChartPreviewRouteRepository = exports.alertsChartPreviewRouteRepository = {
  ...transactionErrorRateChartPreview,
  ...transactionErrorCountChartPreview,
  ...transactionDurationChartPreview
};