"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelineAxis = TimelineAxis;
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _formatters = require("../../../../../common/utils/formatters");
var _marker = require("./marker");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/charts/timeline/timeline_axis.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// Remove any tick that is too close to topTraceDuration
const getXAxisTickValues = (tickValues, topTraceDuration) => {
  if (topTraceDuration == null) {
    return tickValues;
  }
  const padding = (tickValues[1] - tickValues[0]) / 2;
  const lowerBound = topTraceDuration - padding;
  const upperBound = topTraceDuration + padding;
  return tickValues.filter(value => {
    const isInRange = (0, _lodash.inRange)(value, lowerBound, upperBound);
    return !isInRange && value !== topTraceDuration;
  });
};
function TimelineAxis({
  plotValues,
  marks = [],
  topTraceDuration
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    margins,
    tickValues,
    width,
    xMax,
    xScale
  } = plotValues;
  const tickFormatter = (0, _formatters.getDurationFormatter)(xMax);
  const tickPositionsAndLabels = getXAxisTickValues(tickValues, topTraceDuration).reduce((ticks, tick) => {
    const position = xScale(tick);
    return Number.isFinite(position) ? [...ticks, {
      position,
      label: tickFormatter(tick).formatted
    }] : ticks;
  }, []);
  const topTraceDurationPosition = topTraceDuration > 0 ? xScale(topTraceDuration) : NaN;
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      height: margins.top,
      width: '100%'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("svg", {
    style: {
      position: 'absolute',
      top: 0,
      left: 0
    },
    width: width,
    height: margins.top,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("g", {
    transform: `translate(0 ${margins.top - 20})`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  }, tickPositionsAndLabels.map(({
    position,
    label
  }) => /*#__PURE__*/_react.default.createElement("text", {
    key: `tick-${position}`,
    x: position,
    y: 0,
    textAnchor: "middle",
    fill: euiTheme.colors.darkShade,
    fontSize: 11,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 13
    }
  }, label)), Number.isFinite(topTraceDurationPosition) && /*#__PURE__*/_react.default.createElement("text", {
    key: "topTrace",
    x: topTraceDurationPosition,
    y: 0,
    fill: euiTheme.colors.textParagraph,
    textAnchor: "middle",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 13
    }
  }, tickFormatter(topTraceDuration).formatted))), marks.map(mark => {
    var _xScale;
    return /*#__PURE__*/_react.default.createElement(_marker.Marker, {
      key: mark.id,
      mark: mark,
      x: (_xScale = xScale(mark.offset)) !== null && _xScale !== void 0 ? _xScale : 0,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 9
      }
    });
  }));
}