"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNoDataConfig = getNoDataConfig;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getNoDataConfigDetails({
  addDataUrl
}) {
  return {
    title: _i18n.i18n.translate('xpack.apm.noDataConfig.title', {
      defaultMessage: 'Monitor your applications'
    }),
    href: addDataUrl,
    description: _i18n.i18n.translate('xpack.apm.noDataConfig.description', {
      defaultMessage: 'Collect traces, metrics, and logs from your application.'
    }),
    buttonText: _i18n.i18n.translate('xpack.apm.noDataConfig.addDataButtonLabel', {
      defaultMessage: 'Add data'
    })
  };
}
function getNoDataConfig({
  docsLink,
  shouldBypassNoDataScreen,
  loading,
  addDataUrl,
  hasApmData
}) {
  // don't show "no data screen" when there is APM data or it should be bypassed
  if (hasApmData || shouldBypassNoDataScreen || loading) {
    return;
  }
  const noDataConfigDetails = getNoDataConfigDetails({
    addDataUrl
  });
  return {
    action: {
      elasticAgent: {
        title: noDataConfigDetails.title,
        description: noDataConfigDetails.description,
        href: noDataConfigDetails.href,
        buttonText: noDataConfigDetails.buttonText,
        'data-test-subj': 'apmNoDataCard',
        docsLink
      }
    }
  };
}