"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransactionFlyout = TransactionFlyout;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/observability-plugin/common");
var _react = _interopRequireDefault(require("react"));
var _use_fetcher = require("../../../../../../../hooks/use_fetcher");
var _transaction_metadata = require("../../../../../../shared/metadata_table/transaction_metadata");
var _span_links_tab_content = require("../../../../../../shared/span_links/span_links_tab_content");
var _transaction_summary = require("../../../../../../shared/summary/transaction_summary");
var _transaction_action_menu = require("../../../../../../shared/transaction_action_menu/transaction_action_menu");
var _flyout_top_level_properties = require("../flyout_top_level_properties");
var _responsive_flyout = require("../responsive_flyout");
var _dropped_spans_warning = require("./dropped_spans_warning");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/transaction_details/waterfall_with_summary/waterfall_container/waterfall/transaction_flyout/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function TransactionFlyout({
  transactionId,
  traceId,
  onClose,
  errorCount = 0,
  rootTransactionDuration,
  spanLinksCount,
  flyoutDetailTab,
  start,
  end
}) {
  const {
    data: transaction,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/traces/{traceId}/transactions/{transactionId}', {
      params: {
        path: {
          traceId,
          transactionId
        },
        query: {
          start,
          end
        }
      }
    });
  }, [traceId, transactionId, start, end]);
  const isLoading = (0, _use_fetcher.isPending)(status);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_responsive_flyout.ResponsiveFlyout, {
    onClose: onClose,
    ownFocus: true,
    maxWidth: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.apm.transactionDetails.transFlyout.transactionDetailsTitle', {
    defaultMessage: 'Transaction details'
  })))), transaction && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_transaction_action_menu.TransactionActionMenu, {
    isLoading: false,
    transaction: transaction,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    isLoading: isLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 11
    }
  }, transaction && /*#__PURE__*/_react.default.createElement(TransactionFlyoutBody, {
    transaction: transaction,
    errorCount: errorCount,
    rootTransactionDuration: rootTransactionDuration,
    spanLinksCount: spanLinksCount,
    flyoutDetailTab: flyoutDetailTab,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 15
    }
  })))));
}
function TransactionFlyoutBody({
  transaction,
  errorCount,
  rootTransactionDuration,
  spanLinksCount,
  flyoutDetailTab
}) {
  var _transaction$trace, _transaction$transact, _tabs$find, _transaction$faas;
  const spanLinksTabContent = (0, _span_links_tab_content.getSpanLinksTabContent)({
    spanLinksCount,
    traceId: (_transaction$trace = transaction.trace) === null || _transaction$trace === void 0 ? void 0 : _transaction$trace.id,
    spanId: (_transaction$transact = transaction.transaction) === null || _transaction$transact === void 0 ? void 0 : _transaction$transact.id,
    processorEvent: _common.ProcessorEvent.transaction
  });
  const tabs = [{
    id: 'metadata',
    name: _i18n.i18n.translate('xpack.apm.propertiesTable.tabs.metadataLabel', {
      defaultMessage: 'Metadata'
    }),
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_transaction_metadata.TransactionMetadata, {
      transaction: transaction,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 11
      }
    }))
  }, ...(spanLinksTabContent ? [spanLinksTabContent] : [])];
  const initialTab = (_tabs$find = tabs.find(({
    id
  }) => id === flyoutDetailTab)) !== null && _tabs$find !== void 0 ? _tabs$find : tabs[0];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_flyout_top_level_properties.FlyoutTopLevelProperties, {
    transaction: transaction,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_transaction_summary.TransactionSummary, {
    transaction: transaction,
    totalDuration: rootTransactionDuration,
    errorCount: errorCount,
    coldStartBadge: (_transaction$faas = transaction.faas) === null || _transaction$faas === void 0 ? void 0 : _transaction$faas.coldstart,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_dropped_spans_warning.DroppedSpansWarning, {
    transactionDoc: transaction,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    initialSelectedTab: initialTab,
    tabs: tabs,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 7
    }
  }));
}