"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmDeleteModal = ConfirmDeleteModal;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _all_option = require("../../../../../../common/agent_configuration/all_option");
var _create_call_apm_api = require("../../../../../services/rest/create_call_apm_api");
var _use_apm_plugin_context = require("../../../../../context/apm_plugin/use_apm_plugin_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/settings/agent_configurations/list/confirm_delete_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ConfirmDeleteModal({
  config,
  onCancel,
  onConfirm
}) {
  const [isDeleting, setIsDeleting] = (0, _react.useState)(false);
  const {
    toasts
  } = (0, _use_apm_plugin_context.useApmPluginContext)().core.notifications;
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    title: _i18n.i18n.translate('xpack.apm.agentConfig.deleteModal.title', {
      defaultMessage: `Delete configuration`
    }),
    titleProps: {
      id: modalTitleId
    },
    onCancel: onCancel,
    onConfirm: async () => {
      setIsDeleting(true);
      await deleteConfig(config, toasts);
      setIsDeleting(false);
      onConfirm();
    },
    cancelButtonText: _i18n.i18n.translate('xpack.apm.agentConfig.deleteModal.cancel', {
      defaultMessage: `Cancel`
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.apm.agentConfig.deleteModal.confirm', {
      defaultMessage: `Delete`
    }),
    confirmButtonDisabled: isDeleting,
    buttonColor: "danger",
    defaultFocusedButton: "confirm",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.apm.agentConfig.deleteModal.text', {
    defaultMessage: `You are about to delete the configuration for service "{serviceName}" and environment "{environment}".`,
    values: {
      serviceName: (0, _all_option.getOptionLabel)(config.service.name),
      environment: (0, _all_option.getOptionLabel)(config.service.environment)
    }
  })));
}
async function deleteConfig(config, toasts) {
  try {
    await (0, _create_call_apm_api.callApmApi)('DELETE /api/apm/settings/agent-configuration 2023-10-31', {
      signal: null,
      params: {
        body: {
          service: {
            name: config.service.name,
            environment: config.service.environment
          }
        }
      }
    });
    toasts.addSuccess({
      title: _i18n.i18n.translate('xpack.apm.agentConfig.deleteSection.deleteConfigSucceededTitle', {
        defaultMessage: 'Configuration was deleted'
      }),
      text: _i18n.i18n.translate('xpack.apm.agentConfig.deleteSection.deleteConfigSucceededText', {
        defaultMessage: 'You have successfully deleted a configuration for "{serviceName}". It will take some time to propagate to the agents.',
        values: {
          serviceName: (0, _all_option.getOptionLabel)(config.service.name)
        }
      })
    });
  } catch (error) {
    toasts.addDanger({
      title: _i18n.i18n.translate('xpack.apm.agentConfig.deleteSection.deleteConfigFailedTitle', {
        defaultMessage: 'Configuration could not be deleted'
      }),
      text: _i18n.i18n.translate('xpack.apm.agentConfig.deleteSection.deleteConfigFailedText', {
        defaultMessage: 'Something went wrong when deleting a configuration for "{serviceName}". Error: "{errorMessage}"',
        values: {
          serviceName: (0, _all_option.getOptionLabel)(config.service.name),
          errorMessage: error.message
        }
      })
    });
  }
}