"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.retryTransientEsErrors = void 0;
var _coreElasticsearchServerUtils = require("@kbn/core-elasticsearch-server-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_ATTEMPTS = 3;
const delay = ms => new Promise(resolve => setTimeout(resolve, ms));
const retryTransientEsErrors = async (esCall, {
  logger,
  attempt = 0
}) => {
  try {
    return await esCall();
  } catch (e) {
    if (attempt < MAX_ATTEMPTS && (0, _coreElasticsearchServerUtils.isRetryableEsClientError)(e)) {
      const retryCount = attempt + 1;
      const retryDelaySec = Math.min(Math.pow(2, retryCount), 30); // 2s, 4s, 8s, 16s, 30s, 30s, 30s...

      logger.warn(`Retrying Elasticsearch operation after [${retryDelaySec}s] due to error: ${e.toString()} ${e.stack}`);

      // delay with some randomness
      await delay(retryDelaySec * 1000 * Math.random());
      return retryTransientEsErrors(esCall, {
        logger,
        attempt: retryCount
      });
    }
    throw e;
  }
};
exports.retryTransientEsErrors = retryTransientEsErrors;