"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetMaintenanceWindow = void 0;
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@tanstack/react-query");
var _kibana_react = require("../utils/kibana_react");
var _get = require("../services/maintenance_windows_api/get");
var _convert_from_maintenance_window_to_form = require("../pages/maintenance_windows/helpers/convert_from_maintenance_window_to_form");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetMaintenanceWindow = maintenanceWindowId => {
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana_react.useKibana)().services;
  const queryFn = async () => {
    const maintenanceWindow = await (0, _get.getMaintenanceWindow)({
      http,
      maintenanceWindowId
    });
    const hasScopedQuery = !!maintenanceWindow.scopedQuery;
    const hasOldCategorySettings = maintenanceWindow.categoryIds ? maintenanceWindow.categoryIds.length > 0 && maintenanceWindow.categoryIds.length < 3 : false;
    const showMultipleSolutionsWarning = !hasScopedQuery && hasOldCategorySettings;
    return {
      maintenanceWindow: (0, _convert_from_maintenance_window_to_form.convertFromMaintenanceWindowToForm)(maintenanceWindow),
      showMultipleSolutionsWarning
    };
  };
  const onErrorFn = () => {
    toasts.addDanger(_i18n.i18n.translate('xpack.alerting.getMaintenanceWindowFailure', {
      defaultMessage: 'Unable to get maintenance window.'
    }));
  };
  const {
    isInitialLoading,
    isLoading,
    data,
    isError
  } = (0, _reactQuery.useQuery)({
    queryKey: ['getMaintenanceWindow', maintenanceWindowId],
    queryFn,
    onError: onErrorFn,
    refetchOnWindowFocus: false,
    retry: false,
    cacheTime: 0
  });
  return {
    maintenanceWindow: data === null || data === void 0 ? void 0 : data.maintenanceWindow,
    showMultipleSolutionsWarning: data === null || data === void 0 ? void 0 : data.showMultipleSolutionsWarning,
    isLoading: isLoading || isInitialLoading,
    isError
  };
};
exports.useGetMaintenanceWindow = useGetMaintenanceWindow;