"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.streamEndWithUpdatedLoadingStateFactory = void 0;
var _i18n = require("@kbn/i18n");
var _stream_reducer = require("@kbn/aiops-log-rate-analysis/api/stream_reducer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Helper function that will push a message to the stream that it's done and
 * then run a callback to end the actual stream.
 * This is implemented as a factory that receives the necessary dependencies
 * which then returns the actual helper function.
 */
const streamEndWithUpdatedLoadingStateFactory = (streamEndCallback, push) => {
  return function endWithUpdatedLoadingState() {
    push((0, _stream_reducer.updateLoadingState)({
      ccsWarning: false,
      loaded: 1,
      loadingState: _i18n.i18n.translate('xpack.aiops.logRateAnalysis.loadingState.doneMessage', {
        defaultMessage: 'Done.'
      })
    }));
    streamEndCallback();
  };
};
exports.streamEndWithUpdatedLoadingStateFactory = streamEndWithUpdatedLoadingStateFactory;