"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PatternAnalysisSettings = exports.EmbeddableMenu = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _sampling_panel = require("../sampling_menu/sampling_panel");
var _minimum_time_range = require("./minimum_time_range");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/components/log_categorization/log_categorization_for_embeddable/embeddable_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const minimumTimeRangeOptions = Object.entries(_minimum_time_range.MINIMUM_TIME_RANGE).map(([key, {
  label
}]) => ({
  inputDisplay: label,
  value: key
}));
const EmbeddableMenu = ({
  randomSampler,
  minimumTimeRangeOption,
  setMinimumTimeRangeOption,
  categoryCount,
  reload
}) => {
  const [showMenu, setShowMenu] = (0, _react.useState)(false);
  const togglePopover = () => setShowMenu(!showMenu);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.aiops.logCategorization.embeddableMenu.tooltip', {
      defaultMessage: 'Options'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "aiopsEmbeddableMenuOptionsButton",
    size: "s",
    iconType: "controlsHorizontal",
    onClick: () => togglePopover()
    // @ts-expect-error - subdued does work
    ,
    color: "subdued",
    "aria-label": _i18n.i18n.translate('xpack.aiops.logCategorization.embeddableMenu.aria', {
      defaultMessage: 'Pattern analysis options'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: 'embeddableMenu',
    button: button,
    isOpen: showMenu,
    closePopover: () => togglePopover(),
    panelPaddingSize: "s",
    anchorPosition: "downRight",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    paddingSize: "s",
    css: {
      maxWidth: '400px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.aiops.logCategorization.embeddableMenu.patternAnalysisSettingsTitle",
    defaultMessage: " Pattern analysis settings",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(PatternAnalysisSettings, {
    minimumTimeRangeOption: minimumTimeRangeOption,
    setMinimumTimeRangeOption: setMinimumTimeRangeOption,
    categoryCount: categoryCount,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_sampling_panel.SamplingPanel, {
    randomSampler: randomSampler,
    reload: reload,
    calloutPosition: "bottom",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  })));
};
exports.EmbeddableMenu = EmbeddableMenu;
const PatternAnalysisSettings = ({
  minimumTimeRangeOption,
  setMinimumTimeRangeOption,
  categoryCount,
  compressed = false
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    "data-test-subj": "aiopsRandomSamplerOptionsFormRow",
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      responsive: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      css: {
        textWrap: 'nowrap'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.aiops.logCategorization.embeddableMenu.minimumTimeRangeOptionsRowLabel', {
      defaultMessage: 'Minimum time range'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.aiops.logCategorization.embeddableMenu.minimumTimeRange.tooltip', {
        defaultMessage: 'Adds a wider time range to the analysis to improve pattern accuracy.'
      }),
      type: "question",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 15
      }
    }))),
    helpText: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, categoryCount !== undefined && minimumTimeRangeOption !== 'No minimum' ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.logCategorization.embeddableMenu.totalPatternsMessage",
      defaultMessage: "Total patterns in {minimumTimeRangeOption}: {categoryCount}",
      values: {
        minimumTimeRangeOption,
        categoryCount
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 17
      }
    })) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.logCategorization.embeddableMenu.totalPatternsMessage2",
      defaultMessage: "No additional time will be added to the range you specified with the time selector.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 15
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    fullWidth: true,
    "aria-label": _i18n.i18n.translate('xpack.aiops.logCategorization.embeddableMenu.minimumTimeRangeOptionsRowAriaLabel', {
      defaultMessage: 'Select a minimum time range'
    }),
    options: minimumTimeRangeOptions,
    valueOfSelected: minimumTimeRangeOption,
    onChange: setMinimumTimeRangeOption,
    compressed: compressed,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 9
    }
  })));
};
exports.PatternAnalysisSettings = PatternAnalysisSettings;