"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogRateAnalysisReduxProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _toolkit = require("@reduxjs/toolkit");
var _reactRedux = require("react-redux");
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _client = require("@kbn/ml-response-stream/client");
var _stream_reducer = require("../api/stream_reducer");
var _log_rate_analysis_slice = require("./log_rate_analysis_slice");
var _log_rate_analysis_table_slice = require("./log_rate_analysis_table_slice");
var _log_rate_analysis_field_candidates_slice = require("./log_rate_analysis_field_candidates_slice");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/packages/shared/ml/aiops_log_rate_analysis/state/store.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getReduxStore = () => (0, _toolkit.configureStore)({
  preloadedState: {
    logRateAnalysisTable: (0, _log_rate_analysis_table_slice.getPreloadedState)()
  },
  reducer: {
    // General page state
    logRateAnalysis: _log_rate_analysis_slice.logRateAnalysisSlice.reducer,
    // Field candidates
    logRateAnalysisFieldCandidates: _log_rate_analysis_field_candidates_slice.logRateAnalysisFieldCandidatesSlice.reducer,
    // Analysis results
    logRateAnalysisResults: _stream_reducer.logRateAnalysisResultsSlice.reducer,
    // Handles running the analysis, needs to be "stream" for the async thunk to work properly.
    stream: _client.streamSlice.reducer,
    // Handles hovering and pinning table rows and column selection
    logRateAnalysisTable: _log_rate_analysis_table_slice.logRateAnalysisTableSlice.reducer
  },
  middleware: getDefaultMiddleware => getDefaultMiddleware().prepend(_log_rate_analysis_table_slice.localStorageListenerMiddleware.middleware)
});
const LogRateAnalysisReduxProvider = ({
  children,
  initialAnalysisStart
}) => {
  const store = (0, _react.useMemo)(getReduxStore, []);
  (0, _useMount.default)(() => {
    if (initialAnalysisStart) {
      store.dispatch(_log_rate_analysis_slice.logRateAnalysisSlice.actions.setInitialAnalysisStart(initialAnalysisStart));
    }
  });
  return /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: store,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 10
    }
  }, children);
};

// Infer the `RootState` and `AppDispatch` types from the store itself
exports.LogRateAnalysisReduxProvider = LogRateAnalysisReduxProvider;