"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AIOPS_PLUGIN_ID = exports.AIOPS_EMBEDDABLE_ORIGIN = exports.AIOPS_EMBEDDABLE_GROUPING = exports.AIOPS_API_ENDPOINT = exports.AIOPS_ANALYSIS_RUN_ORIGIN = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * AIOPS_PLUGIN_ID is used as a unique identifier for the aiops plugin
 */
const AIOPS_PLUGIN_ID = exports.AIOPS_PLUGIN_ID = 'aiops';
const AIOPS_API_ENDPOINT = exports.AIOPS_API_ENDPOINT = {
  LOG_RATE_ANALYSIS_FIELD_CANDIDATES: '/internal/aiops/log_rate_analysis/field_candidates',
  LOG_RATE_ANALYSIS: '/internal/aiops/log_rate_analysis',
  CATEGORIZATION_FIELD_VALIDATION: '/internal/aiops/categorization_field_validation'
};

/**
 * Used for telemetry purposes to track the origin of the analysis run.
 */
const AIOPS_ANALYSIS_RUN_ORIGIN = exports.AIOPS_ANALYSIS_RUN_ORIGIN = 'aiops-analysis-run-origin';
const AIOPS_EMBEDDABLE_ORIGIN = exports.AIOPS_EMBEDDABLE_ORIGIN = {
  CASES: 'cases',
  DASHBOARD: 'dashboard',
  DEFAULT: 'embeddable',
  DISCOVER: 'discover',
  ML_AIOPS_LABS: 'ml_aiops_labs'
};
const AIOPS_EMBEDDABLE_GROUPING = exports.AIOPS_EMBEDDABLE_GROUPING = [{
  id: 'logs-aiops',
  getDisplayName: () => _i18n.i18n.translate('xpack.aiops.embedabble.groupingDisplayName', {
    defaultMessage: 'Log analysis'
  }),
  getIconType: () => 'machineLearningApp'
}];