"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const vitest_1 = require("vitest");
(0, vitest_1.describe)('BindToFluentSyntax', () => {
    let containerMock;
    (0, vitest_1.beforeAll)(() => {
        containerMock = {
            get: vitest_1.vitest.fn(),
        };
    });
    (0, vitest_1.describe)('.get', () => {
        (0, vitest_1.describe)('having a ServiceIdentifier<T>', () => {
            class Foo {
            }
            let serviceIdentifierFixture;
            (0, vitest_1.beforeAll)(() => {
                serviceIdentifierFixture = Symbol();
            });
            (0, vitest_1.it)('should return infer T when called with ServiceIdentifier<T>', () => {
                (0, vitest_1.expectTypeOf)(containerMock.get(serviceIdentifierFixture)).toEqualTypeOf();
            });
            (0, vitest_1.it)('should return infer T when called with generic T', () => {
                (0, vitest_1.expectTypeOf)(containerMock.get(Symbol())).toEqualTypeOf();
            });
        });
    });
});
//# sourceMappingURL=Container.spec-d.js.map