"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isAnyAncestorBindingConstraints = isAnyAncestorBindingConstraints;
function isAnyAncestorBindingConstraints(condition) {
    return (constraints) => {
        for (let ancestorMetadata = constraints.getAncestor(); ancestorMetadata !== undefined; ancestorMetadata = ancestorMetadata.getAncestor()) {
            if (condition(ancestorMetadata)) {
                return true;
            }
        }
        return false;
    };
}
//# sourceMappingURL=isAnyAncestorBindingConstraints.js.map