"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.shadows = exports.shadowPrimitives = void 0;
var _euiThemeCommon = require("@elastic/eui-theme-common");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
// in Amsterdam this is `color.shadow`, which computes to `ink` (#000)
var SHADOW_COLOR = '#000000';
var shadowPrimitives = exports.shadowPrimitives = {
  xs: {
    light: [{
      opacity: 0.04 * 1,
      x: 0,
      y: 0.8,
      blur: 0.8,
      spread: 0
    }, {
      opacity: 0.03 * 1,
      x: 0,
      y: 2.3,
      blur: 2,
      spread: 0
    }],
    dark: [{
      opacity: 0.04 * 3.5,
      x: 0,
      y: 0.8,
      blur: 0.8,
      spread: 0
    }, {
      opacity: 0.03 * 3.5,
      x: 0,
      y: 2.3,
      blur: 2,
      spread: 0
    }]
  },
  s: {
    light: [{
      opacity: 0.07 * 1,
      x: 0,
      y: 0.7,
      blur: 1.4,
      spread: 0
    }, {
      opacity: 0.05 * 1,
      x: 0,
      y: 1.9,
      blur: 4,
      spread: 0
    }, {
      opacity: 0.05 * 1,
      x: 0,
      y: 4.5,
      blur: 10,
      spread: 0
    }],
    dark: [{
      opacity: 0.07 * 3.5,
      x: 0,
      y: 0.7,
      blur: 1.4,
      spread: 0
    }, {
      opacity: 0.05 * 3.5,
      x: 0,
      y: 1.9,
      blur: 4,
      spread: 0
    }, {
      opacity: 0.05 * 3.5,
      x: 0,
      y: 4.5,
      blur: 10,
      spread: 0
    }]
  },
  m: {
    light: [{
      opacity: 0.08 * 1,
      x: 0,
      y: 0.9,
      blur: 4,
      spread: 0
    }, {
      opacity: 0.06 * 1,
      x: 0,
      y: 2.6,
      blur: 8,
      spread: 0
    }, {
      opacity: 0.05 * 1,
      x: 0,
      y: 5.7,
      blur: 12,
      spread: 0
    }, {
      opacity: 0.04 * 1,
      x: 0,
      y: 15,
      blur: 15,
      spread: 0
    }],
    dark: [{
      opacity: 0.08 * 3.5,
      x: 0,
      y: 0.9,
      blur: 4,
      spread: 0
    }, {
      opacity: 0.06 * 3.5,
      x: 0,
      y: 2.6,
      blur: 8,
      spread: 0
    }, {
      opacity: 0.05 * 3.5,
      x: 0,
      y: 5.7,
      blur: 12,
      spread: 0
    }, {
      opacity: 0.04 * 3.5,
      x: 0,
      y: 15,
      blur: 15,
      spread: 0
    }]
  },
  l: {
    light: [{
      opacity: 0.1 * 1,
      x: 0,
      y: 1,
      blur: 5,
      spread: 0
    }, {
      opacity: 0.07 * 1,
      x: 0,
      y: 3.6,
      blur: 13,
      spread: 0
    }, {
      opacity: 0.06 * 1,
      x: 0,
      y: 8.4,
      blur: 23,
      spread: 0
    }, {
      opacity: 0.05 * 1,
      x: 0,
      y: 23,
      blur: 35,
      spread: 0
    }],
    dark: [{
      opacity: 0.1 * 3.5,
      x: 0,
      y: 1,
      blur: 5,
      spread: 0
    }, {
      opacity: 0.07 * 3.5,
      x: 0,
      y: 3.6,
      blur: 13,
      spread: 0
    }, {
      opacity: 0.06 * 3.5,
      x: 0,
      y: 8.4,
      blur: 23,
      spread: 0
    }, {
      opacity: 0.05 * 3.5,
      x: 0,
      y: 23,
      blur: 35,
      spread: 0
    }]
  },
  xl: {
    light: [{
      opacity: 0.13 * 1,
      x: 0,
      y: 2.7,
      blur: 9,
      spread: 0
    }, {
      opacity: 0.09 * 1,
      x: 0,
      y: 9.4,
      blur: 24,
      spread: 0
    }, {
      opacity: 0.08 * 1,
      x: 0,
      y: 21.8,
      blur: 43,
      spread: 0
    }],
    dark: [{
      opacity: 0.13 * 3.5,
      x: 0,
      y: 2.7,
      blur: 9,
      spread: 0
    }, {
      opacity: 0.09 * 3.5,
      x: 0,
      y: 9.4,
      blur: 24,
      spread: 0
    }, {
      opacity: 0.08 * 3.5,
      x: 0,
      y: 21.8,
      blur: 43,
      spread: 0
    }]
  },
  xxl: {
    light: [],
    dark: []
  },
  flat: {
    light: [{
      opacity: 0.06 * 1,
      x: 0,
      y: 0,
      blur: 0.8,
      spread: 0
    }, {
      opacity: 0.04 * 1,
      x: 0,
      y: 0,
      blur: 2,
      spread: 0
    }, {
      opacity: 0.04 * 1,
      x: 0,
      y: 0,
      blur: 5,
      spread: 0
    }, {
      opacity: 0.03 * 1,
      x: 0,
      y: 0,
      blur: 17,
      spread: 0
    }],
    dark: [{
      opacity: 0.06 * 3.5,
      x: 0,
      y: 0,
      blur: 0.8,
      spread: 0
    }, {
      opacity: 0.04 * 3.5,
      x: 0,
      y: 0,
      blur: 2,
      spread: 0
    }, {
      opacity: 0.04 * 3.5,
      x: 0,
      y: 0,
      blur: 5,
      spread: 0
    }, {
      opacity: 0.03 * 3.5,
      x: 0,
      y: 0,
      blur: 17,
      spread: 0
    }]
  }
};
var shadowColors = {
  colors: {
    base: SHADOW_COLOR
  }
};
var shadowsLight = _objectSpread(_objectSpread({}, shadowColors), {}, {
  xs: {
    down: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.xs.light, {
      color: shadowColors.colors.base
    }),
    up: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.xs.light, {
      direction: 'up',
      color: shadowColors.colors.base
    })
  },
  s: {
    down: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.s.light, {
      color: shadowColors.colors.base
    }),
    up: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.s.light, {
      direction: 'up',
      color: shadowColors.colors.base
    })
  },
  m: {
    down: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.m.light, {
      color: shadowColors.colors.base
    }),
    up: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.m.light, {
      direction: 'up',
      color: shadowColors.colors.base
    })
  },
  l: {
    down: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.l.light, {
      color: shadowColors.colors.base
    }),
    up: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.l.light, {
      direction: 'up',
      color: shadowColors.colors.base
    })
  },
  xl: {
    down: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.xl.light, {
      color: shadowColors.colors.base
    }),
    up: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.xl.light, {
      direction: 'up',
      color: shadowColors.colors.base
    })
  },
  hover: {
    base: {
      down: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.s.light.slice(1), {
        color: shadowColors.colors.base
      }),
      up: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.s.light.slice(1), {
        direction: 'up',
        color: shadowColors.colors.base
      })
    },
    xl: {
      down: 'none',
      up: 'none'
    }
  },
  flat: {
    down: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.flat.light, {
      color: shadowColors.colors.base
    }),
    up: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.flat.light, {
      direction: 'up',
      color: shadowColors.colors.base
    })
  }
});
var shadowsDark = _objectSpread(_objectSpread({}, shadowColors), {}, {
  xs: {
    down: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.xs.dark, {
      color: shadowColors.colors.base
    }),
    up: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.xs.dark, {
      direction: 'up',
      color: shadowColors.colors.base
    })
  },
  s: {
    down: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.s.dark, {
      color: shadowColors.colors.base
    }),
    up: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.s.dark, {
      direction: 'up',
      color: shadowColors.colors.base
    })
  },
  m: {
    down: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.m.dark, {
      color: shadowColors.colors.base
    }),
    up: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.m.dark, {
      direction: 'up',
      color: shadowColors.colors.base
    })
  },
  l: {
    down: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.l.dark, {
      color: shadowColors.colors.base
    }),
    up: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.l.dark, {
      direction: 'up',
      color: shadowColors.colors.base
    })
  },
  xl: {
    down: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.xl.dark, {
      color: shadowColors.colors.base
    }),
    up: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.xl.dark, {
      direction: 'up',
      color: shadowColors.colors.base
    })
  },
  hover: {
    base: {
      down: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.s.dark.slice(1), {
        color: shadowColors.colors.base
      }),
      up: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.s.dark.slice(1), {
        direction: 'up',
        color: shadowColors.colors.base
      })
    },
    xl: {
      down: 'none',
      up: 'none'
    }
  },
  flat: {
    down: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.flat.dark, {
      color: shadowColors.colors.base
    }),
    up: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.flat.dark, {
      direction: 'up',
      color: shadowColors.colors.base
    })
  }
});
var shadows = exports.shadows = {
  LIGHT: shadowsLight,
  DARK: shadowsDark
};