"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiMarkdownEditorTextAreaStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _form = require("../form/form.styles");
var _markdown_editor = require("./markdown_editor.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiMarkdownEditorTextAreaStyles = exports.euiMarkdownEditorTextAreaStyles = function euiMarkdownEditorTextAreaStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiMarkdownEditorVar = (0, _markdown_editor.euiMarkdownEditorVariables)(euiThemeContext),
    minHeight = _euiMarkdownEditorVar.minHeight;
  var borderCSS = "\n    border: ".concat(euiTheme.border.thin, ";\n    ").concat((0, _global_styling.logicalCSS)('border-bottom', 'none'), "\n  ");
  return {
    euiMarkdownEditorTextArea: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalSizeCSS)('100%'), " ", (0, _global_styling.logicalCSS)('min-height', minHeight), " ", (0, _global_styling.euiScrollBarStyles)(euiThemeContext), " resize:vertical;margin:0;padding:", euiTheme.size.m, ";", (0, _form.euiFormControlText)(euiThemeContext), " line-height:", euiTheme.font.lineHeightMultiplier, ";;label:euiMarkdownEditorTextArea;"),
    readOnly: /*#__PURE__*/(0, _react.css)(borderCSS, " background-color:", euiTheme.colors.emptyShade, ";cursor:default;&:focus{outline:none;};label:readOnly;"),
    editable: /*#__PURE__*/(0, _react.css)((0, _form.euiFormControlDefaultShadow)(euiThemeContext), borderCSS, " box-shadow:none;&:focus,.euiMarkdownEditor:focus-within &{", (0, _form.euiFormControlFocusStyles)(euiThemeContext), ";};label:editable;")
  };
};