"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiFormControlLayoutStyles = exports.euiFormControlLayoutSideNodeStyles = void 0;
var _react = require("@emotion/react");
var _services = require("../../../services");
var _global_styling = require("../../../global_styling");
var _high_contrast = require("../../../global_styling/functions/high_contrast");
var _form = require("../form.styles");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1lbfa6m-euiFormControlLayout__childrenWrapper",
  styles: "position:relative;label:euiFormControlLayout__childrenWrapper;"
} : {
  name: "1lbfa6m-euiFormControlLayout__childrenWrapper",
  styles: "position:relative;label:euiFormControlLayout__childrenWrapper;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "12dhv84-euiFormControlLayout",
  styles: "position:relative;z-index:0;label:euiFormControlLayout;"
} : {
  name: "12dhv84-euiFormControlLayout",
  styles: "position:relative;z-index:0;label:euiFormControlLayout;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiFormControlLayoutStyles = exports.euiFormControlLayoutStyles = function euiFormControlLayoutStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var isRefreshVariant = (0, _services.isEuiThemeRefreshVariant)(euiThemeContext, 'formVariant');
  var form = (0, _form.euiFormVariables)(euiThemeContext);
  var groupStyles = "\n      /* use pseudo element for borders to prevent dimension changes and support nested elements better */\n      &::after {\n        content: '';\n        position: absolute;\n        inset: 0;\n        z-index: 0;\n        border: ".concat(euiTheme.border.width.thin, " solid ").concat(form.borderColor, ";\n        border-radius: inherit;\n        pointer-events: none;\n      }\n\n      /* the filter group will use the form layout border instead */\n      .euiFilterGroup {\n        border-radius: 0;\n        /* creating extra space to prevent the focus indicator being cut off */\n        ").concat((0, _global_styling.logicalCSS)('padding-right', euiTheme.border.width.thin), "\n\n        &::after {\n          display: none;\n        }\n      }\n\n      .euiFilterButton__wrapper:first-of-type::before,\n      .euiFilterButton__wrapper::after {\n        display: none;\n      }\n  ");
  var wrapperGroupStyles = "\n      > :first-child {\n        border-radius: inherit;\n        ".concat((0, _global_styling.logicalCSS)('border-top-left-radius', '0'), "\n        ").concat((0, _global_styling.logicalCSS)('border-bottom-left-radius', '0'), "\n      }\n\n      > :last-child {\n        border-radius: inherit;\n        ").concat((0, _global_styling.logicalCSS)('border-top-right-radius', '0'), "\n        ").concat((0, _global_styling.logicalCSS)('border-bottom-right-radius', '0'), "\n      }\n  ");
  var prependOnlyStyles = "\n      > :last-child {\n        ".concat((0, _global_styling.logicalCSS)('border-top-right-radius', 'inherit'), "\n        ").concat((0, _global_styling.logicalCSS)('border-bottom-right-radius', 'inherit'), "\n      }\n  ");
  var appendOnlyStyles = "\n      > :first-child {\n        ".concat((0, _global_styling.logicalCSS)('border-top-left-radius', 'inherit'), "\n        ").concat((0, _global_styling.logicalCSS)('border-bottom-left-radius', 'inherit'), "\n      }\n  ");
  return {
    euiFormControlLayout: _ref2,
    // Skip the css`` on the default height to avoid generating a className
    uncompressed: "\n      ".concat((0, _global_styling.logicalCSS)('height', form.controlHeight), "\n    "),
    compressed: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', form.controlCompressedHeight), ";;label:compressed;"),
    // Skip the css`` on the default width to avoid generating a className
    formWidth: "\n      ".concat((0, _global_styling.logicalCSS)('max-width', form.maxWidth), "\n      ").concat((0, _global_styling.logicalCSS)('width', '100%'), "\n    "),
    fullWidth: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('max-width', '100%'), " ", (0, _global_styling.logicalCSS)('width', '100%'), ";;label:fullWidth;"),
    group: {
      group: /*#__PURE__*/(0, _react.css)("position:relative;display:flex;align-items:stretch;border:", isRefreshVariant ? 'none' : "".concat(euiTheme.border.width.thin, " solid ").concat(form.borderColor), ";background-color:", form.backgroundColor, ";overflow:hidden;", isRefreshVariant && groupStyles, " .euiFormControlButton{border-radius:inherit;box-shadow:none;}>*{", (0, _global_styling.logicalCSS)('height', '100%'), ";};label:group;"),
      // Skipping css`` to avoid repeated compressed/uncompressed classNames
      uncompressed: "\n        border-radius: ".concat(form.controlBorderRadius, ";\n      "),
      compressed: "\n        border-radius: ".concat(form.controlCompressedBorderRadius, ";\n      ")
    },
    children: {
      euiFormControlLayout__childrenWrapper: _ref,
      inGroup: /*#__PURE__*/(0, _react.css)("flex-grow:1;overflow:hidden;", isRefreshVariant && wrapperGroupStyles, ";;label:inGroup;"),
      prependOnly: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('border-top-right-radius', 'inherit'), " ", (0, _global_styling.logicalCSS)('border-bottom-right-radius', 'inherit'), " ", isRefreshVariant && prependOnlyStyles, ";;label:prependOnly;"),
      appendOnly: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('border-top-left-radius', 'inherit'), " ", (0, _global_styling.logicalCSS)('border-bottom-left-radius', 'inherit'), " ", isRefreshVariant && appendOnlyStyles, ";;label:appendOnly;")
    }
  };
};
var euiFormControlLayoutSideNodeStyles = exports.euiFormControlLayoutSideNodeStyles = function euiFormControlLayoutSideNodeStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var isRefreshVariant = (0, _services.isEuiThemeRefreshVariant)(euiThemeContext, 'formVariant');
  var form = (0, _form.euiFormVariables)(euiThemeContext);
  var uncompressedHeight = (0, _global_styling.mathWithUnits)([form.controlHeight, euiTheme.border.width.thin], function (x, y) {
    return isRefreshVariant ? x : x - y * 2;
  });
  var compressedHeight = (0, _global_styling.mathWithUnits)([form.controlCompressedHeight, euiTheme.border.width.thin], function (x, y) {
    return isRefreshVariant ? x : x - y * 2;
  });
  var buttons = '*:is(.euiButton, .euiButtonEmpty, .euiButtonIcon)';
  var text = '*:is(.euiFormLabel, .euiText)';
  var appendStyles = "\n    position: relative;\n    ".concat((0, _global_styling.logicalCSS)('margin-left', "-".concat(euiTheme.border.width.thin)), "\n\n    &::before {\n      content: '';\n      position: absolute;\n      inset: 0;\n      pointer-events: none;\n      border-inline-start: \n        ").concat(euiTheme.border.width.thin, " solid ").concat(form.borderColor, ";\n    }\n  ");
  var prependStyles = "\n    position: relative;\n    ".concat((0, _global_styling.logicalCSS)('margin-right', "-".concat(euiTheme.border.width.thin)), "\n\n    &::before {\n      content: '';\n      position: absolute;\n      inset: 0;\n      z-index: 1;\n      pointer-events: none;\n      border-inline-end: \n        ").concat(euiTheme.border.width.thin, " solid ").concat(form.borderColor, ";\n    }\n  ");
  return {
    euiFormControlLayout__side: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', '100%'), " ", (0, _global_styling.euiTextTruncate)('50%'), " flex-shrink:0;display:flex;align-items:center;gap:", euiTheme.size.xs, ";background-color:", form.appendPrependBackground, ";", buttons, "{transform:none!important;&:focus-visible{outline-offset:-", euiTheme.focus.width, ";}}", text, "{cursor:default;overflow:hidden;text-overflow:ellipsis;}&:not(:has(> ", buttons, ":first-child, > *:first-child > ", buttons, ")){", (0, _global_styling.logicalCSS)('padding-left', euiTheme.size.s), ";}&:not(:has(> ", buttons, ":last-child, > *:last-child > ", buttons, ")){", (0, _global_styling.logicalCSS)('padding-right', euiTheme.size.s), ";};label:euiFormControlLayout__side;"),
    append: /*#__PURE__*/(0, _react.css)((0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
      none: "\n          ".concat(isRefreshVariant && appendStyles, "\n        "),
      preferred: (0, _global_styling.logicalCSS)('border-left', euiTheme.border.thin)
    }), ";label:append;"),
    prepend: /*#__PURE__*/(0, _react.css)((0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
      none: "\n          ".concat(isRefreshVariant && prependStyles, "\n        "),
      preferred: (0, _global_styling.logicalCSS)('border-right', euiTheme.border.thin)
    }), ";label:prepend;"),
    uncompressed: "\n      ".concat(text, " {\n        ").concat((0, _global_styling.logicalCSS)('padding-horizontal', euiTheme.size.xs), "\n        line-height: ").concat(uncompressedHeight, ";\n      }\n\n      ").concat(buttons, " {\n        ").concat((0, _global_styling.logicalCSS)('height', uncompressedHeight), "\n      }\n\n      .euiButtonIcon {\n        flex-shrink: 0;\n        ").concat((0, _global_styling.logicalCSS)('width', euiTheme.size.xl), "\n      }\n    "),
    compressed: /*#__PURE__*/(0, _react.css)(text, "{", (0, _global_styling.logicalCSS)('padding-horizontal', euiTheme.size.xxs), " line-height:", compressedHeight, ";}", buttons, "{", (0, _global_styling.logicalCSS)('height', compressedHeight), ";}.euiButtonIcon{flex-shrink:0;", (0, _global_styling.logicalCSS)('width', euiTheme.size.xl), ";};label:compressed;")
  };
};