"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiDataGridColumnResizerStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../../global_styling");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
// Resizer straddles the column border and is an invisible hitzone for dragging
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1i9vv3a-isDragging",
  styles: "opacity:1;label:isDragging;"
} : {
  name: "1i9vv3a-isDragging",
  styles: "opacity:1;label:isDragging;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiDataGridColumnResizerStyles = exports.euiDataGridColumnResizerStyles = function euiDataGridColumnResizerStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var clickableWidth = euiTheme.size.base;
  var positionOffset = (0, _global_styling.mathWithUnits)(clickableWidth, function (x) {
    return x / -2;
  });
  var indicatorWidth = (0, _global_styling.mathWithUnits)([euiTheme.border.width.thin, euiTheme.border.width.thick], function (x, y) {
    return x + y;
  }); // Odd number because it straddles a border
  var indicatorOffset = "-".concat(euiTheme.border.width.thin);
  return {
    euiDataGridColumnResizer: /*#__PURE__*/(0, _react.css)("z-index:2;position:absolute;", (0, _global_styling.logicalCSS)('vertical', 0), " ", (0, _global_styling.logicalCSS)('right', positionOffset), " cursor:ew-resize;opacity:0;&:hover,&:active{opacity:1;}&::after{content:'';position:absolute;", (0, _global_styling.logicalCSS)('vertical', 0), " ", (0, _global_styling.logicalCSS)('left', positionOffset), " ", (0, _global_styling.logicalCSS)('margin-left', indicatorOffset), " ", (0, _global_styling.logicalCSS)('width', indicatorWidth), " background-color:", euiTheme.colors.primary, ";};label:euiDataGridColumnResizer;"),
    /* Because the resizer sits in the negative space to the right of the column,
     * it can cause the full grid to be a few pixels longer than it actually is.
     * So for the last cell, we don't use negative positioning and the borders from
     * the cell will match the container. */
    isLastColumn: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('right', 0), " ", (0, _global_styling.logicalCSS)('width', euiTheme.size.s), " &::after{", (0, _global_styling.logicalCSS)('left', 'auto'), " ", (0, _global_styling.logicalCSS)('right', 0), ";};label:isLastColumn;"),
    isDragging: _ref
  };
};