"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Label = Label;
exports.NonInteractiveLabel = NonInteractiveLabel;
const classnames_1 = __importDefault(require("classnames"));
const react_1 = __importStar(require("react"));
const common_1 = require("../../utils/common");
const isAppleDevice = typeof window !== 'undefined' && /Mac|iPhone|iPad/.test(window.navigator.userAgent);
const modifierKey = isAppleDevice ? '⌘' : 'Ctrl';
const showAllSeriesMessage = 'to show all';
const showSeriesMessage = 'to show';
const hideSeriesMessage = 'to hide';
function getInteractivityTitle(isSeriesVisible, hiddenSeries, allSeries) {
    if (isSeriesVisible) {
        if (allSeries - hiddenSeries === 1) {
            return `
Click ${showAllSeriesMessage}
${modifierKey} + Click ${hideSeriesMessage}`;
        }
        if (hiddenSeries > 0) {
            return `
Click ${hideSeriesMessage}`;
        }
        return `
Click ${showSeriesMessage}
${modifierKey} + Click ${hideSeriesMessage}`;
    }
    return `
Click ${showSeriesMessage}`;
}
function getInteractivityAriaLabel(isSeriesVisible, hiddenSeries, allSeries) {
    if (isSeriesVisible) {
        if (allSeries - hiddenSeries === 1) {
            return `Click: ${showAllSeriesMessage}, ${modifierKey} + Click: ${hideSeriesMessage}`;
        }
        if (hiddenSeries > 0) {
            return `Click: ${hideSeriesMessage}, ${modifierKey} + Click: ${hideSeriesMessage}`;
        }
        return `Click: ${showSeriesMessage}, ${modifierKey} + Click: ${hideSeriesMessage}`;
    }
    return `Click: ${showSeriesMessage}, ${modifierKey} + Click: ${showSeriesMessage}`;
}
function Label({ label, onToggle, isToggleable, isSeriesHidden, options, hiddenSeriesCount, totalSeriesCount, }) {
    const { className, dir, clampStyles } = getSharedProps(label, options, !!onToggle);
    const onClick = (0, react_1.useCallback)(({ metaKey, ctrlKey }) => onToggle?.(isAppleDevice ? metaKey : ctrlKey), [onToggle]);
    const onKeyDown = (0, react_1.useCallback)(({ key, metaKey, ctrlKey }) => {
        if (key === ' ' || key === 'Enter')
            onToggle?.(isAppleDevice ? metaKey : ctrlKey);
    }, [onToggle]);
    const title = options.maxLines > 0 ? label : '';
    return isToggleable ? (react_1.default.createElement("div", { role: "button", tabIndex: 0, dir: dir, className: className, title: `${title}\n${getInteractivityTitle(!isSeriesHidden, hiddenSeriesCount, totalSeriesCount)}`, onClick: onClick, onKeyDown: onKeyDown, "aria-pressed": isSeriesHidden, style: clampStyles, "aria-label": `${label}; ${getInteractivityAriaLabel(!isSeriesHidden, hiddenSeriesCount, totalSeriesCount)}`, "data-testid": "echLegendItemLabel" }, label)) : (react_1.default.createElement("div", { dir: dir, className: className, title: label, style: clampStyles, "data-testid": "echLegendItemLabel" }, label));
}
function NonInteractiveLabel({ label, options }) {
    const { className, dir, clampStyles } = getSharedProps(label, options);
    return (react_1.default.createElement("div", { dir: dir, className: className, title: label, style: clampStyles, "data-testid": "echLegendItemLabel" }, label));
}
function getSharedProps(label, options, isToggleable) {
    const maxLines = Math.abs(options.maxLines);
    const className = (0, classnames_1.default)('echLegendItem__label', {
        'echLegendItem__label--clickable': Boolean(isToggleable),
        'echLegendItem__label--singleline': maxLines === 1,
        'echLegendItem__label--multiline': maxLines > 1,
    });
    const dir = (0, common_1.isRTLString)(label) ? 'rtl' : 'ltr';
    const clampStyles = maxLines > 1 ? { WebkitLineClamp: maxLines } : {};
    return { className, dir, clampStyles };
}
//# sourceMappingURL=label.js.map