import { SENSITIVE_STRING } from "@smithy/smithy-client";
import { KendraServiceException as __BaseException } from "./KendraServiceException";
export class AccessDeniedException extends __BaseException {
    name = "AccessDeniedException";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "AccessDeniedException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, AccessDeniedException.prototype);
        this.Message = opts.Message;
    }
}
export const HighlightType = {
    STANDARD: "STANDARD",
    THESAURUS_SYNONYM: "THESAURUS_SYNONYM",
};
export const AdditionalResultAttributeValueType = {
    TEXT_WITH_HIGHLIGHTS_VALUE: "TEXT_WITH_HIGHLIGHTS_VALUE",
};
export const AlfrescoEntity = {
    blog: "blog",
    documentLibrary: "documentLibrary",
    wiki: "wiki",
};
export const EntityType = {
    GROUP: "GROUP",
    USER: "USER",
};
export class InternalServerException extends __BaseException {
    name = "InternalServerException";
    $fault = "server";
    Message;
    constructor(opts) {
        super({
            name: "InternalServerException",
            $fault: "server",
            ...opts,
        });
        Object.setPrototypeOf(this, InternalServerException.prototype);
        this.Message = opts.Message;
    }
}
export class ResourceAlreadyExistException extends __BaseException {
    name = "ResourceAlreadyExistException";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "ResourceAlreadyExistException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ResourceAlreadyExistException.prototype);
        this.Message = opts.Message;
    }
}
export class ResourceNotFoundException extends __BaseException {
    name = "ResourceNotFoundException";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "ResourceNotFoundException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ResourceNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
export class ThrottlingException extends __BaseException {
    name = "ThrottlingException";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "ThrottlingException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ThrottlingException.prototype);
        this.Message = opts.Message;
    }
}
export class ValidationException extends __BaseException {
    name = "ValidationException";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "ValidationException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ValidationException.prototype);
        this.Message = opts.Message;
    }
}
export const Persona = {
    OWNER: "OWNER",
    VIEWER: "VIEWER",
};
export const AttributeSuggestionsMode = {
    ACTIVE: "ACTIVE",
    INACTIVE: "INACTIVE",
};
export const ErrorCode = {
    INTERNAL_ERROR: "InternalError",
    INVALID_REQUEST: "InvalidRequest",
};
export class ConflictException extends __BaseException {
    name = "ConflictException";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "ConflictException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ConflictException.prototype);
        this.Message = opts.Message;
    }
}
export const DocumentStatus = {
    FAILED: "FAILED",
    INDEXED: "INDEXED",
    NOT_FOUND: "NOT_FOUND",
    PROCESSING: "PROCESSING",
    UPDATED: "UPDATED",
    UPDATE_FAILED: "UPDATE_FAILED",
};
export const ConditionOperator = {
    BeginsWith: "BeginsWith",
    Contains: "Contains",
    Equals: "Equals",
    Exists: "Exists",
    GreaterThan: "GreaterThan",
    GreaterThanOrEquals: "GreaterThanOrEquals",
    LessThan: "LessThan",
    LessThanOrEquals: "LessThanOrEquals",
    NotContains: "NotContains",
    NotEquals: "NotEquals",
    NotExists: "NotExists",
};
export const ReadAccessType = {
    ALLOW: "ALLOW",
    DENY: "DENY",
};
export const PrincipalType = {
    GROUP: "GROUP",
    USER: "USER",
};
export const ContentType = {
    CSV: "CSV",
    HTML: "HTML",
    JSON: "JSON",
    MD: "MD",
    MS_EXCEL: "MS_EXCEL",
    MS_WORD: "MS_WORD",
    PDF: "PDF",
    PLAIN_TEXT: "PLAIN_TEXT",
    PPT: "PPT",
    RTF: "RTF",
    XML: "XML",
    XSLT: "XSLT",
};
export class ServiceQuotaExceededException extends __BaseException {
    name = "ServiceQuotaExceededException";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "ServiceQuotaExceededException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ServiceQuotaExceededException.prototype);
        this.Message = opts.Message;
    }
}
export const ConfluenceAttachmentFieldName = {
    AUTHOR: "AUTHOR",
    CONTENT_TYPE: "CONTENT_TYPE",
    CREATED_DATE: "CREATED_DATE",
    DISPLAY_URL: "DISPLAY_URL",
    FILE_SIZE: "FILE_SIZE",
    ITEM_TYPE: "ITEM_TYPE",
    PARENT_ID: "PARENT_ID",
    SPACE_KEY: "SPACE_KEY",
    SPACE_NAME: "SPACE_NAME",
    URL: "URL",
    VERSION: "VERSION",
};
export const ConfluenceAuthenticationType = {
    HTTP_BASIC: "HTTP_BASIC",
    PAT: "PAT",
};
export const ConfluenceBlogFieldName = {
    AUTHOR: "AUTHOR",
    DISPLAY_URL: "DISPLAY_URL",
    ITEM_TYPE: "ITEM_TYPE",
    LABELS: "LABELS",
    PUBLISH_DATE: "PUBLISH_DATE",
    SPACE_KEY: "SPACE_KEY",
    SPACE_NAME: "SPACE_NAME",
    URL: "URL",
    VERSION: "VERSION",
};
export const ConfluencePageFieldName = {
    AUTHOR: "AUTHOR",
    CONTENT_STATUS: "CONTENT_STATUS",
    CREATED_DATE: "CREATED_DATE",
    DISPLAY_URL: "DISPLAY_URL",
    ITEM_TYPE: "ITEM_TYPE",
    LABELS: "LABELS",
    MODIFIED_DATE: "MODIFIED_DATE",
    PARENT_ID: "PARENT_ID",
    SPACE_KEY: "SPACE_KEY",
    SPACE_NAME: "SPACE_NAME",
    URL: "URL",
    VERSION: "VERSION",
};
export const ConfluenceSpaceFieldName = {
    DISPLAY_URL: "DISPLAY_URL",
    ITEM_TYPE: "ITEM_TYPE",
    SPACE_KEY: "SPACE_KEY",
    URL: "URL",
};
export const ConfluenceVersion = {
    CLOUD: "CLOUD",
    SERVER: "SERVER",
};
export const DatabaseEngineType = {
    RDS_AURORA_MYSQL: "RDS_AURORA_MYSQL",
    RDS_AURORA_POSTGRESQL: "RDS_AURORA_POSTGRESQL",
    RDS_MYSQL: "RDS_MYSQL",
    RDS_POSTGRESQL: "RDS_POSTGRESQL",
};
export const QueryIdentifiersEnclosingOption = {
    DOUBLE_QUOTES: "DOUBLE_QUOTES",
    NONE: "NONE",
};
export const FsxFileSystemType = {
    WINDOWS: "WINDOWS",
};
export const Type = {
    ON_PREMISE: "ON_PREMISE",
    SAAS: "SAAS",
};
export const IssueSubEntity = {
    ATTACHMENTS: "ATTACHMENTS",
    COMMENTS: "COMMENTS",
    WORKLOGS: "WORKLOGS",
};
export const SalesforceChatterFeedIncludeFilterType = {
    ACTIVE_USER: "ACTIVE_USER",
    STANDARD_USER: "STANDARD_USER",
};
export const SalesforceKnowledgeArticleState = {
    ARCHIVED: "ARCHIVED",
    DRAFT: "DRAFT",
    PUBLISHED: "PUBLISHED",
};
export const SalesforceStandardObjectName = {
    ACCOUNT: "ACCOUNT",
    CAMPAIGN: "CAMPAIGN",
    CASE: "CASE",
    CONTACT: "CONTACT",
    CONTRACT: "CONTRACT",
    DOCUMENT: "DOCUMENT",
    GROUP: "GROUP",
    IDEA: "IDEA",
    LEAD: "LEAD",
    OPPORTUNITY: "OPPORTUNITY",
    PARTNER: "PARTNER",
    PRICEBOOK: "PRICEBOOK",
    PRODUCT: "PRODUCT",
    PROFILE: "PROFILE",
    SOLUTION: "SOLUTION",
    TASK: "TASK",
    USER: "USER",
};
export const ServiceNowAuthenticationType = {
    HTTP_BASIC: "HTTP_BASIC",
    OAUTH2: "OAUTH2",
};
export const ServiceNowBuildVersionType = {
    LONDON: "LONDON",
    OTHERS: "OTHERS",
};
export const SharePointOnlineAuthenticationType = {
    HTTP_BASIC: "HTTP_BASIC",
    OAUTH2: "OAUTH2",
};
export const SharePointVersion = {
    SHAREPOINT_2013: "SHAREPOINT_2013",
    SHAREPOINT_2016: "SHAREPOINT_2016",
    SHAREPOINT_2019: "SHAREPOINT_2019",
    SHAREPOINT_ONLINE: "SHAREPOINT_ONLINE",
};
export const SlackEntity = {
    DIRECT_MESSAGE: "DIRECT_MESSAGE",
    GROUP_MESSAGE: "GROUP_MESSAGE",
    PRIVATE_CHANNEL: "PRIVATE_CHANNEL",
    PUBLIC_CHANNEL: "PUBLIC_CHANNEL",
};
export const WebCrawlerMode = {
    EVERYTHING: "EVERYTHING",
    HOST_ONLY: "HOST_ONLY",
    SUBDOMAINS: "SUBDOMAINS",
};
export const DataSourceType = {
    ALFRESCO: "ALFRESCO",
    BOX: "BOX",
    CONFLUENCE: "CONFLUENCE",
    CUSTOM: "CUSTOM",
    DATABASE: "DATABASE",
    FSX: "FSX",
    GITHUB: "GITHUB",
    GOOGLEDRIVE: "GOOGLEDRIVE",
    JIRA: "JIRA",
    ONEDRIVE: "ONEDRIVE",
    QUIP: "QUIP",
    S3: "S3",
    SALESFORCE: "SALESFORCE",
    SERVICENOW: "SERVICENOW",
    SHAREPOINT: "SHAREPOINT",
    SLACK: "SLACK",
    TEMPLATE: "TEMPLATE",
    WEBCRAWLER: "WEBCRAWLER",
    WORKDOCS: "WORKDOCS",
};
export const FaqFileFormat = {
    CSV: "CSV",
    CSV_WITH_HEADER: "CSV_WITH_HEADER",
    JSON: "JSON",
};
export const FeaturedResultsSetStatus = {
    ACTIVE: "ACTIVE",
    INACTIVE: "INACTIVE",
};
export class FeaturedResultsConflictException extends __BaseException {
    name = "FeaturedResultsConflictException";
    $fault = "client";
    Message;
    ConflictingItems;
    constructor(opts) {
        super({
            name: "FeaturedResultsConflictException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, FeaturedResultsConflictException.prototype);
        this.Message = opts.Message;
        this.ConflictingItems = opts.ConflictingItems;
    }
}
export const IndexEdition = {
    DEVELOPER_EDITION: "DEVELOPER_EDITION",
    ENTERPRISE_EDITION: "ENTERPRISE_EDITION",
    GEN_AI_ENTERPRISE_EDITION: "GEN_AI_ENTERPRISE_EDITION",
};
export const UserContextPolicy = {
    ATTRIBUTE_FILTER: "ATTRIBUTE_FILTER",
    USER_TOKEN: "USER_TOKEN",
};
export const UserGroupResolutionMode = {
    AWS_SSO: "AWS_SSO",
    NONE: "NONE",
};
export const KeyLocation = {
    SECRET_MANAGER: "SECRET_MANAGER",
    URL: "URL",
};
export const DataSourceStatus = {
    ACTIVE: "ACTIVE",
    CREATING: "CREATING",
    DELETING: "DELETING",
    FAILED: "FAILED",
    UPDATING: "UPDATING",
};
export const EndpointType = {
    HOME: "HOME",
};
export const ExperienceStatus = {
    ACTIVE: "ACTIVE",
    CREATING: "CREATING",
    DELETING: "DELETING",
    FAILED: "FAILED",
};
export const FaqStatus = {
    ACTIVE: "ACTIVE",
    CREATING: "CREATING",
    DELETING: "DELETING",
    FAILED: "FAILED",
    UPDATING: "UPDATING",
};
export const Order = {
    ASCENDING: "ASCENDING",
    DESCENDING: "DESCENDING",
};
export const DocumentAttributeValueType = {
    DATE_VALUE: "DATE_VALUE",
    LONG_VALUE: "LONG_VALUE",
    STRING_LIST_VALUE: "STRING_LIST_VALUE",
    STRING_VALUE: "STRING_VALUE",
};
export const IndexStatus = {
    ACTIVE: "ACTIVE",
    CREATING: "CREATING",
    DELETING: "DELETING",
    FAILED: "FAILED",
    SYSTEM_UPDATING: "SYSTEM_UPDATING",
    UPDATING: "UPDATING",
};
export const PrincipalMappingStatus = {
    DELETED: "DELETED",
    DELETING: "DELETING",
    FAILED: "FAILED",
    PROCESSING: "PROCESSING",
    SUCCEEDED: "SUCCEEDED",
};
export const QuerySuggestionsBlockListStatus = {
    ACTIVE: "ACTIVE",
    ACTIVE_BUT_UPDATE_FAILED: "ACTIVE_BUT_UPDATE_FAILED",
    CREATING: "CREATING",
    DELETING: "DELETING",
    FAILED: "FAILED",
    UPDATING: "UPDATING",
};
export const Mode = {
    ENABLED: "ENABLED",
    LEARN_ONLY: "LEARN_ONLY",
};
export const QuerySuggestionsStatus = {
    ACTIVE: "ACTIVE",
    UPDATING: "UPDATING",
};
export const ThesaurusStatus = {
    ACTIVE: "ACTIVE",
    ACTIVE_BUT_UPDATE_FAILED: "ACTIVE_BUT_UPDATE_FAILED",
    CREATING: "CREATING",
    DELETING: "DELETING",
    FAILED: "FAILED",
    UPDATING: "UPDATING",
};
export const SuggestionType = {
    DOCUMENT_ATTRIBUTES: "DOCUMENT_ATTRIBUTES",
    QUERY: "QUERY",
};
export const Interval = {
    ONE_MONTH_AGO: "ONE_MONTH_AGO",
    ONE_WEEK_AGO: "ONE_WEEK_AGO",
    THIS_MONTH: "THIS_MONTH",
    THIS_WEEK: "THIS_WEEK",
    TWO_MONTHS_AGO: "TWO_MONTHS_AGO",
    TWO_WEEKS_AGO: "TWO_WEEKS_AGO",
};
export const MetricType = {
    AGG_QUERY_DOC_METRICS: "AGG_QUERY_DOC_METRICS",
    DOCS_BY_CLICK_COUNT: "DOCS_BY_CLICK_COUNT",
    QUERIES_BY_COUNT: "QUERIES_BY_COUNT",
    QUERIES_BY_ZERO_CLICK_RATE: "QUERIES_BY_ZERO_CLICK_RATE",
    QUERIES_BY_ZERO_RESULT_RATE: "QUERIES_BY_ZERO_RESULT_RATE",
    TREND_QUERY_DOC_METRICS: "TREND_QUERY_DOC_METRICS",
};
export class InvalidRequestException extends __BaseException {
    name = "InvalidRequestException";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "InvalidRequestException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidRequestException.prototype);
        this.Message = opts.Message;
    }
}
export const DataSourceSyncJobStatus = {
    ABORTED: "ABORTED",
    FAILED: "FAILED",
    INCOMPLETE: "INCOMPLETE",
    STOPPING: "STOPPING",
    SUCCEEDED: "SUCCEEDED",
    SYNCING: "SYNCING",
    SYNCING_INDEXING: "SYNCING_INDEXING",
};
export class ResourceUnavailableException extends __BaseException {
    name = "ResourceUnavailableException";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "ResourceUnavailableException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ResourceUnavailableException.prototype);
        this.Message = opts.Message;
    }
}
export const MissingAttributeKeyStrategy = {
    COLLAPSE: "COLLAPSE",
    EXPAND: "EXPAND",
    IGNORE: "IGNORE",
};
export const SortOrder = {
    ASC: "ASC",
    DESC: "DESC",
};
export const QueryResultType = {
    ANSWER: "ANSWER",
    DOCUMENT: "DOCUMENT",
    QUESTION_ANSWER: "QUESTION_ANSWER",
};
export const QueryResultFormat = {
    TABLE: "TABLE",
    TEXT: "TEXT",
};
export const ServerSideEncryptionConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.KmsKeyId && { KmsKeyId: SENSITIVE_STRING }),
});
export const CreateIndexRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ServerSideEncryptionConfiguration && {
        ServerSideEncryptionConfiguration: ServerSideEncryptionConfigurationFilterSensitiveLog(obj.ServerSideEncryptionConfiguration),
    }),
});
export const DescribeIndexResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ServerSideEncryptionConfiguration && {
        ServerSideEncryptionConfiguration: ServerSideEncryptionConfigurationFilterSensitiveLog(obj.ServerSideEncryptionConfiguration),
    }),
});
export const EntityDisplayDataFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.UserName && { UserName: SENSITIVE_STRING }),
    ...(obj.GroupName && { GroupName: SENSITIVE_STRING }),
    ...(obj.IdentifiedUserName && { IdentifiedUserName: SENSITIVE_STRING }),
    ...(obj.FirstName && { FirstName: SENSITIVE_STRING }),
    ...(obj.LastName && { LastName: SENSITIVE_STRING }),
});
export const ExperienceEntitiesSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.DisplayData && { DisplayData: EntityDisplayDataFilterSensitiveLog(obj.DisplayData) }),
});
export const ListExperienceEntitiesResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SummaryItems && {
        SummaryItems: obj.SummaryItems.map((item) => ExperienceEntitiesSummaryFilterSensitiveLog(item)),
    }),
});
