/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.telemetry;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.xpack.core.watcher.common.stats.Counters;
import org.elasticsearch.xpack.esql.core.expression.function.Function;
import org.elasticsearch.xpack.esql.expression.function.EsqlFunctionRegistry;
import org.elasticsearch.xpack.esql.expression.function.FunctionDefinition;
import org.elasticsearch.xpack.esql.telemetry.FeatureMetric;
import org.elasticsearch.xpack.esql.telemetry.QueryMetric;
import org.elasticsearch.xpack.esql.telemetry.TookMetrics;

public class Metrics {
    protected static final String QUERIES_PREFIX = "queries.";
    protected static final String FEATURES_PREFIX = "features.";
    protected static final String FUNC_PREFIX = "functions.";
    protected static final String TOOK_PREFIX = "took.";
    private final Map<QueryMetric, Map<OperationType, CounterMetric>> opsByTypeMetrics;
    private final Map<FeatureMetric, CounterMetric> featuresMetrics;
    private final Map<String, CounterMetric> functionMetrics;
    private final TookMetrics tookMetrics = new TookMetrics();
    private final EsqlFunctionRegistry functionRegistry;
    private final Map<Class<?>, String> classToFunctionName;

    public Metrics(EsqlFunctionRegistry functionRegistry) {
        this.functionRegistry = functionRegistry.snapshotRegistry();
        this.classToFunctionName = this.initClassToFunctionType();
        LinkedHashMap qMap = new LinkedHashMap();
        for (QueryMetric metric : QueryMetric.values()) {
            LinkedHashMap metricsMap = Maps.newLinkedHashMapWithExpectedSize((int)OperationType.values().length);
            for (OperationType type : OperationType.values()) {
                metricsMap.put(type, new CounterMetric());
            }
            qMap.put(metric, Collections.unmodifiableMap(metricsMap));
        }
        this.opsByTypeMetrics = Collections.unmodifiableMap(qMap);
        LinkedHashMap fMap = Maps.newLinkedHashMapWithExpectedSize((int)FeatureMetric.values().length);
        for (FeatureMetric featureMetric : FeatureMetric.values()) {
            fMap.put(featureMetric, new CounterMetric());
        }
        this.featuresMetrics = Collections.unmodifiableMap(fMap);
        this.functionMetrics = this.initFunctionMetrics();
    }

    private Map<String, CounterMetric> initFunctionMetrics() {
        LinkedHashMap<String, CounterMetric> result = new LinkedHashMap<String, CounterMetric>();
        for (Map.Entry<Class<?>, String> entry : this.classToFunctionName.entrySet()) {
            result.put(entry.getValue(), new CounterMetric());
        }
        return Collections.unmodifiableMap(result);
    }

    private Map<Class<?>, String> initClassToFunctionType() {
        HashMap<Class<? extends Function>, String> tmp = new HashMap<Class<? extends Function>, String>();
        for (FunctionDefinition func : this.functionRegistry.listFunctions()) {
            if (tmp.containsKey(func.clazz())) continue;
            tmp.put(func.clazz(), func.name());
        }
        return Collections.unmodifiableMap(tmp);
    }

    public void total(QueryMetric metric) {
        this.inc(metric, OperationType.TOTAL);
    }

    public void failed(QueryMetric metric) {
        this.inc(metric, OperationType.FAILED);
    }

    private void inc(QueryMetric metric, OperationType op) {
        this.opsByTypeMetrics.get((Object)metric).get((Object)op).inc();
    }

    public void inc(FeatureMetric metric) {
        this.featuresMetrics.get((Object)metric).inc();
    }

    public void incFunctionMetric(Class<?> functionType) {
        String functionName = this.classToFunctionName.get(functionType);
        if (functionName != null) {
            this.functionMetrics.get(functionName).inc();
        }
    }

    public void recordTook(long tookMillis) {
        this.tookMetrics.count(tookMillis);
    }

    public Counters stats() {
        Counters counters = new Counters(new String[0]);
        for (Map.Entry<QueryMetric, Map<OperationType, CounterMetric>> entry : this.opsByTypeMetrics.entrySet()) {
            String metricName = entry.getKey().toString();
            for (OperationType type : OperationType.values()) {
                long metricCounter = entry.getValue().get((Object)type).count();
                String operationTypeName = type.toString();
                counters.inc(QUERIES_PREFIX + metricName + "." + operationTypeName, metricCounter);
                counters.inc("queries._all." + operationTypeName, metricCounter);
            }
        }
        for (Map.Entry<Enum, Map<OperationType, Object>> entry : this.featuresMetrics.entrySet()) {
            counters.inc(FEATURES_PREFIX + ((FeatureMetric)entry.getKey()).toString(), ((CounterMetric)entry.getValue()).count());
        }
        for (Map.Entry<Object, Map<OperationType, Object>> entry : this.functionMetrics.entrySet()) {
            counters.inc(FUNC_PREFIX + (String)entry.getKey(), ((CounterMetric)entry.getValue()).count());
        }
        this.tookMetrics.counters(TOOK_PREFIX, counters);
        return counters;
    }

    private static enum OperationType {
        FAILED,
        TOTAL;


        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

