/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockUtils;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.util.Holder;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PruneEmptyPlans;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.EsRelation;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.Fork;
import org.elasticsearch.xpack.esql.plan.logical.Limit;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.Project;
import org.elasticsearch.xpack.esql.plan.logical.Sample;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.esql.plan.logical.join.InlineJoin;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalRelation;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalSupplier;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;
import org.elasticsearch.xpack.esql.rule.Rule;

public final class PruneColumns
extends Rule<LogicalPlan, LogicalPlan> {
    @Override
    public LogicalPlan apply(LogicalPlan plan) {
        return PruneColumns.pruneColumns(plan, plan.outputSet().asBuilder(), false);
    }

    private static LogicalPlan pruneColumns(LogicalPlan plan, AttributeSet.Builder used, boolean inlineJoin) {
        Holder forkPresent = new Holder((Object)false);
        return (LogicalPlan)plan.transformDown(p -> {
            if (p instanceof Limit || p instanceof Sample) {
                return p;
            }
            if (p instanceof Fork) {
                forkPresent.set((Object)true);
            }
            if (((Boolean)forkPresent.get()).booleanValue()) {
                return p;
            }
            Holder recheck = new Holder();
            do {
                LogicalPlan selector0$temp;
                recheck.set((Object)false);
                Objects.requireNonNull(p);
                int index$1 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Aggregate.class, InlineJoin.class, Eval.class, Project.class, EsRelation.class}, (Object)((Object)selector0$temp), index$1)) {
                    case 0: {
                        Aggregate agg = (Aggregate)selector0$temp;
                        LogicalPlan logicalPlan = PruneColumns.pruneColumnsInAggregate(agg, used, inlineJoin);
                        break;
                    }
                    case 1: {
                        InlineJoin inj = (InlineJoin)selector0$temp;
                        LogicalPlan logicalPlan = PruneColumns.pruneColumnsInInlineJoinRight(inj, used, (Holder<Boolean>)recheck);
                        break;
                    }
                    case 2: {
                        Eval eval = (Eval)selector0$temp;
                        LogicalPlan logicalPlan = PruneColumns.pruneColumnsInEval(eval, used, (Holder<Boolean>)recheck);
                        break;
                    }
                    case 3: {
                        LogicalPlan logicalPlan;
                        Project project = (Project)selector0$temp;
                        if (inlineJoin) {
                            logicalPlan = PruneColumns.pruneColumnsInProject(project, used);
                            break;
                        }
                        logicalPlan = p;
                        break;
                    }
                    case 4: {
                        EsRelation esr = (EsRelation)selector0$temp;
                        LogicalPlan logicalPlan = PruneColumns.pruneColumnsInEsRelation(esr, used);
                        break;
                    }
                    default: {
                        LogicalPlan logicalPlan = p = p;
                    }
                }
            } while (((Boolean)recheck.get()).booleanValue());
            used.addAll(p.references());
            return p;
        });
    }

    private static LogicalPlan pruneColumnsInAggregate(Aggregate aggregate, AttributeSet.Builder used, boolean inlineJoin) {
        LogicalPlan p = aggregate;
        List<? extends NamedExpression> remaining = PruneColumns.pruneUnusedAndAddReferences(aggregate.aggregates(), used);
        if (remaining == null) {
            return p;
        }
        if (remaining.isEmpty()) {
            if (inlineJoin) {
                p = PruneColumns.emptyLocalRelation(aggregate);
            } else if (aggregate.groupings().isEmpty()) {
                p = new LocalRelation(aggregate.source(), List.of(Expressions.attribute((Expression)((Expression)aggregate.aggregates().getFirst()))), LocalSupplier.of(new Page(new Block[]{BlockUtils.constantBlock((BlockFactory)PlannerUtils.NON_BREAKING_BLOCK_FACTORY, null, (int)1)})));
            } else {
                Attribute attribute = Expressions.attribute((Expression)aggregate.groupings().getFirst());
                NamedExpression firstAggregate = aggregate.aggregates().getFirst();
                remaining = List.of(new Alias(firstAggregate.source(), firstAggregate.name(), (Expression)attribute, attribute.id()));
                p = aggregate.with(aggregate.groupings(), remaining);
            }
        } else {
            p = inlineJoin && aggregate.groupings().containsAll(remaining) ? PruneColumns.emptyLocalRelation(aggregate) : aggregate.with(aggregate.groupings(), remaining);
        }
        return p;
    }

    private static LogicalPlan pruneColumnsInInlineJoinRight(InlineJoin ij, AttributeSet.Builder used, Holder<Boolean> recheck) {
        LogicalPlan p = ij;
        used.addAll(ij.references());
        LogicalPlan right = PruneColumns.pruneColumns(ij.right(), used, true);
        if (right.output().isEmpty() || PruneColumns.isLocalEmptyRelation(right)) {
            ArrayList<Attribute> newOutput = new ArrayList<Attribute>(ij.output());
            AttributeSet leftOutputSet = ij.left().outputSet();
            newOutput.removeIf(attr -> !leftOutputSet.contains(attr));
            p = new Project(ij.source(), ij.left(), newOutput);
            recheck.set((Object)true);
        } else if (right != ij.right()) {
            p = ij.replaceRight(right);
        }
        return p;
    }

    private static LogicalPlan pruneColumnsInEval(Eval eval, AttributeSet.Builder used, Holder<Boolean> recheck) {
        LogicalPlan p = eval;
        List<Alias> remaining = PruneColumns.pruneUnusedAndAddReferences(eval.fields(), used);
        if (remaining != null) {
            if (remaining.isEmpty()) {
                p = eval.child();
                recheck.set((Object)true);
            } else {
                p = new Eval(eval.source(), eval.child(), remaining);
            }
        }
        return p;
    }

    private static LogicalPlan pruneColumnsInProject(Project project, AttributeSet.Builder used) {
        LogicalPlan p = project;
        List<? extends NamedExpression> remaining = PruneColumns.pruneUnusedAndAddReferences(project.projections(), used);
        if (remaining != null) {
            p = remaining.isEmpty() ? PruneColumns.emptyLocalRelation(project) : new Project(project.source(), project.child(), remaining);
        }
        return p;
    }

    private static LogicalPlan pruneColumnsInEsRelation(EsRelation esr, AttributeSet.Builder used) {
        List<Attribute> remaining;
        EsRelation p = esr;
        if (esr.indexMode() == IndexMode.LOOKUP && (remaining = PruneColumns.pruneUnusedAndAddReferences(esr.output(), used)) != null) {
            p = new EsRelation(esr.source(), esr.indexPattern(), esr.indexMode(), esr.indexNameWithModes(), remaining);
        }
        return p;
    }

    private static LogicalPlan emptyLocalRelation(UnaryPlan plan) {
        return PruneEmptyPlans.skipPlan(plan);
    }

    private static boolean isLocalEmptyRelation(LogicalPlan plan) {
        LocalRelation local;
        return plan instanceof LocalRelation && (local = (LocalRelation)plan).hasEmptySupplier();
    }

    private static <N extends NamedExpression> List<N> pruneUnusedAndAddReferences(List<N> named, AttributeSet.Builder used) {
        ArrayList<N> clone = new ArrayList<N>(named);
        ListIterator<N> it = clone.listIterator(clone.size());
        while (it.hasPrevious()) {
            NamedExpression prev = (NamedExpression)it.previous();
            Attribute attr = prev.toAttribute();
            if (used.contains((Object)attr)) {
                used.addAll(prev.references());
                continue;
            }
            it.remove();
        }
        return clone.size() != named.size() ? clone : null;
    }
}

