/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import java.util.Arrays;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundTo;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToLong10Evaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToLong1Evaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToLong2Evaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToLong3Evaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToLong4Evaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToLong5Evaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToLong6Evaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToLong7Evaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToLong8Evaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToLong9Evaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToLongBinarySearchEvaluator;

class RoundToLong {
    static final RoundTo.Build BUILD = (source, field, points) -> {
        long[] f = points.stream().mapToLong(p -> ((Number)p).longValue()).toArray();
        return switch (f.length) {
            case 1 -> new RoundToLong1Evaluator.Factory(source, field, f[0]);
            case 2 -> new RoundToLong2Evaluator.Factory(source, field, f[0], f[1]);
            case 3 -> new RoundToLong3Evaluator.Factory(source, field, f[0], f[1], f[2]);
            case 4 -> new RoundToLong4Evaluator.Factory(source, field, f[0], f[1], f[2], f[3]);
            case 5 -> new RoundToLong5Evaluator.Factory(source, field, f[0], f[1], f[2], f[3], f[4]);
            case 6 -> new RoundToLong6Evaluator.Factory(source, field, f[0], f[1], f[2], f[3], f[4], f[5]);
            case 7 -> new RoundToLong7Evaluator.Factory(source, field, f[0], f[1], f[2], f[3], f[4], f[5], f[6]);
            case 8 -> new RoundToLong8Evaluator.Factory(source, field, f[0], f[1], f[2], f[3], f[4], f[5], f[6], f[7]);
            case 9 -> new RoundToLong9Evaluator.Factory(source, field, f[0], f[1], f[2], f[3], f[4], f[5], f[6], f[7], f[8]);
            case 10 -> new RoundToLong10Evaluator.Factory(source, field, f[0], f[1], f[2], f[3], f[4], f[5], f[6], f[7], f[8], f[9]);
            default -> new RoundToLongBinarySearchEvaluator.Factory(source, field, f);
        };
    };

    RoundToLong() {
    }

    static long process(long field, long[] points) {
        int idx = Arrays.binarySearch(points, field);
        return points[idx >= 0 ? idx : Math.max(0, -idx - 2)];
    }

    static long process(long field, long p0) {
        return p0;
    }

    static long process(long field, long p0, long p1) {
        if (field < p1) {
            return p0;
        }
        return p1;
    }

    static long process(long field, long p0, long p1, long p2) {
        if (field < p1) {
            return p0;
        }
        if (field < p2) {
            return p1;
        }
        return p2;
    }

    static long process(long field, long p0, long p1, long p2, long p3) {
        if (field < p1) {
            return p0;
        }
        if (field < p2) {
            return p1;
        }
        if (field < p3) {
            return p2;
        }
        return p3;
    }

    static long process(long field, long p0, long p1, long p2, long p3, long p4) {
        if (field < p2) {
            if (field < p1) {
                return p0;
            }
            return p1;
        }
        if (field < p3) {
            return p2;
        }
        if (field < p4) {
            return p3;
        }
        return p4;
    }

    static long process(long field, long p0, long p1, long p2, long p3, long p4, long p5) {
        if (field < p2) {
            if (field < p1) {
                return p0;
            }
            return p1;
        }
        if (field < p4) {
            if (field < p3) {
                return p2;
            }
            return p3;
        }
        if (field < p5) {
            return p4;
        }
        return p5;
    }

    static long process(long field, long p0, long p1, long p2, long p3, long p4, long p5, long p6) {
        if (field < p3) {
            if (field < p1) {
                return p0;
            }
            if (field < p2) {
                return p1;
            }
            return p2;
        }
        if (field < p5) {
            if (field < p4) {
                return p3;
            }
            return p4;
        }
        if (field < p6) {
            return p5;
        }
        return p6;
    }

    static long process(long field, long p0, long p1, long p2, long p3, long p4, long p5, long p6, long p7) {
        if (field < p3) {
            if (field < p1) {
                return p0;
            }
            if (field < p2) {
                return p1;
            }
            return p2;
        }
        if (field < p5) {
            if (field < p4) {
                return p3;
            }
            return p4;
        }
        if (field < p6) {
            return p5;
        }
        if (field < p7) {
            return p6;
        }
        return p7;
    }

    static long process(long field, long p0, long p1, long p2, long p3, long p4, long p5, long p6, long p7, long p8) {
        if (field < p4) {
            if (field < p1) {
                return p0;
            }
            if (field < p2) {
                return p1;
            }
            if (field < p3) {
                return p2;
            }
            return p3;
        }
        if (field < p6) {
            if (field < p5) {
                return p4;
            }
            return p5;
        }
        if (field < p7) {
            return p6;
        }
        if (field < p8) {
            return p7;
        }
        return p8;
    }

    static long process(long field, long p0, long p1, long p2, long p3, long p4, long p5, long p6, long p7, long p8, long p9) {
        if (field < p4) {
            if (field < p1) {
                return p0;
            }
            if (field < p2) {
                return p1;
            }
            if (field < p3) {
                return p2;
            }
            return p3;
        }
        if (field < p7) {
            if (field < p5) {
                return p4;
            }
            if (field < p6) {
                return p5;
            }
            return p6;
        }
        if (field < p8) {
            return p7;
        }
        if (field < p9) {
            return p8;
        }
        return p9;
    }
}

