/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.conditional;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.ClampMinBooleanEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.ClampMinBytesRefEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.ClampMinDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.ClampMinIntegerEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.ClampMinLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Cast;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;

public class ClampMin
extends EsqlScalarFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "ClampMin", ClampMin::new);

    @FunctionInfo(returnType={"double", "integer", "long", "double", "unsigned_long", "keyword", "ip", "boolean", "date", "version"}, description="Returns clamps the values of all input samples clamped to have a lower limit of min.", examples={@Example(file="k8s-timeseries-clamp", tag="clamp-min")})
    public ClampMin(Source source, @Param(name="field", type={"double", "integer", "long", "double", "unsigned_long", "keyword", "ip", "boolean", "date", "version"}, description="field to clamp.") Expression field, @Param(name="min", type={"double", "integer", "long", "double", "unsigned_long", "keyword", "ip", "boolean", "date", "version"}, description="The min value to clamp data into.") Expression min) {
        super(source, List.of(field, min));
    }

    private ClampMin(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.children().get(0));
        out.writeNamedWriteable((NamedWriteable)this.children().get(1));
    }

    public String getWriteableName() {
        return ClampMin.ENTRY.name;
    }

    public DataType dataType() {
        return ((Expression)this.children().getFirst()).dataType();
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression field = (Expression)this.children().get(0);
        Expression min = (Expression)this.children().get(1);
        DataType fieldDataType = field.dataType();
        Expression.TypeResolution resolution = TypeResolutions.isType((Expression)field, t -> t.isNumeric() || t == DataType.BOOLEAN || t.isDate() || DataType.isString((DataType)t) || t == DataType.IP || t == DataType.VERSION, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST, (String[])new String[]{fieldDataType.typeName()});
        if (resolution.unresolved()) {
            return resolution;
        }
        if (fieldDataType == DataType.NULL) {
            return new Expression.TypeResolution("'field' must not be null in clamp()");
        }
        resolution = TypeResolutions.isType((Expression)min, t -> t.isNumeric() ? fieldDataType.isNumeric() : t.noText() == fieldDataType.noText(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND, (String[])new String[]{fieldDataType.typeName()});
        if (resolution.unresolved()) {
            return resolution;
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new ClampMin(this.source(), newChildren.get(0), newChildren.get(1));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, ClampMin::new, (Object)((Expression)this.children().get(0)), (Object)((Expression)this.children().get(1)));
    }

    public boolean foldable() {
        return Expressions.foldable((List)this.children());
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        DataType outputType = this.dataType();
        Expression min = (Expression)this.children().get(1);
        EvalOperator.ExpressionEvaluator.Factory minF = PlannerUtils.toElementType(outputType) != PlannerUtils.toElementType(min.dataType()) ? Cast.cast(this.source(), min.dataType(), outputType, toEvaluator.apply(min)) : toEvaluator.apply(min);
        return switch (PlannerUtils.toElementType(outputType)) {
            case ElementType.BOOLEAN -> new ClampMinBooleanEvaluator.Factory(this.source(), toEvaluator.apply((Expression)this.children().get(0)), minF);
            case ElementType.DOUBLE -> new ClampMinDoubleEvaluator.Factory(this.source(), toEvaluator.apply((Expression)this.children().get(0)), minF);
            case ElementType.INT -> new ClampMinIntegerEvaluator.Factory(this.source(), toEvaluator.apply((Expression)this.children().get(0)), minF);
            case ElementType.LONG -> new ClampMinLongEvaluator.Factory(this.source(), toEvaluator.apply((Expression)this.children().get(0)), minF);
            case ElementType.BYTES_REF -> new ClampMinBytesRefEvaluator.Factory(this.source(), toEvaluator.apply((Expression)this.children().get(0)), minF);
            default -> throw EsqlIllegalArgumentException.illegalDataType(outputType);
        };
    }

    static boolean process(boolean field, boolean min) {
        if (min) {
            return true;
        }
        return field;
    }

    static BytesRef process(BytesRef field, BytesRef min) {
        return field.compareTo(min) < 0 ? min : field;
    }

    static int process(int field, int min) {
        return Math.max(field, min);
    }

    static long process(long field, long min) {
        return Math.max(field, min);
    }

    static double process(double field, double min) {
        return Math.max(field, min);
    }
}

