/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.SurrogateExpression;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.ClampMax;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.ClampMin;

public class Clamp
extends EsqlScalarFunction
implements SurrogateExpression {
    private final Expression field;
    private final Expression min;
    private final Expression max;

    @FunctionInfo(returnType={"double", "integer", "long", "double", "unsigned_long", "keyword", "ip", "boolean", "date", "version"}, description="Clamps the values of all samples to have a lower limit of min and an upper limit of max.", examples={@Example(file="k8s-timeseries-clamp", tag="clamp")})
    public Clamp(Source source, @Param(name="field", type={"double", "integer", "long", "double", "unsigned_long", "keyword", "ip", "boolean", "date", "version"}, description="Numeric expression. If `null`, the function returns `null`.") Expression field, @Param(name="min", type={"double", "integer", "long", "double", "unsigned_long", "keyword", "ip", "boolean", "date", "version"}, description="The min value to clamp data into.") Expression min, @Param(name="max", type={"double", "integer", "long", "double", "unsigned_long", "keyword", "ip", "boolean", "date", "version"}, description="The max value to clamp data into.") Expression max) {
        super(source, List.of(field, min, max));
        this.field = field;
        this.min = min;
        this.max = max;
    }

    public String getWriteableName() {
        throw new UnsupportedOperationException("Clamp does not support serialization.");
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression field = (Expression)this.children().get(0);
        DataType fieldDataType = field.dataType().noText();
        Expression.TypeResolution resolution = TypeResolutions.isType((Expression)field, t -> t.isNumeric() || t == DataType.BOOLEAN || t.isDate() || DataType.isString((DataType)t) || t == DataType.IP || t == DataType.VERSION, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST, (String[])new String[]{fieldDataType.typeName()});
        if (resolution.unresolved()) {
            return resolution;
        }
        if (fieldDataType == DataType.NULL) {
            return new Expression.TypeResolution("'field' must not be null in clamp()");
        }
        for (Expression child : List.of((Expression)this.children().get(1), (Expression)this.children().get(2))) {
            Expression.TypeResolution childRes = TypeResolutions.isType((Expression)child, t -> t.isNumeric() ? fieldDataType.isNumeric() : t.noText() == fieldDataType, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)(child == this.children().get(1) ? TypeResolutions.ParamOrdinal.SECOND : TypeResolutions.ParamOrdinal.THIRD), (String[])new String[]{fieldDataType.typeName()});
            if (!childRes.unresolved()) continue;
            return childRes;
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    public DataType dataType() {
        return this.field.dataType();
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Clamp(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Clamp::new, (Object)this.field, (Object)((Expression)this.children().get(1)), (Object)((Expression)this.children().get(2)));
    }

    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException("Clamp does not support serialization.");
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        throw new UnsupportedOperationException("Clamp should have been replaced by ClampMin and ClampMax. Something went wrong in the compute engine.");
    }

    @Override
    public Expression surrogate() {
        return new ClampMax(this.source(), (Expression)new ClampMin(this.source(), this.field, this.min), this.max);
    }
}

