/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.fulltext;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.esql.capabilities.PostAnalysisPlanVerificationAware;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.InvalidArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.MapExpression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.Check;
import org.elasticsearch.xpack.esql.core.util.NumericUtils;
import org.elasticsearch.xpack.esql.expression.Foldables;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.MapParam;
import org.elasticsearch.xpack.esql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.esql.expression.function.Options;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.fulltext.FullTextFunction;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.EsqlBinaryComparison;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.LucenePushdownPredicates;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.planner.TranslatorHandler;
import org.elasticsearch.xpack.esql.querydsl.query.MatchQuery;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

public class Match
extends FullTextFunction
implements OptionalArgument,
PostAnalysisPlanVerificationAware {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Match", Match::readFrom);
    public static final Set<DataType> FIELD_DATA_TYPES = Set.of(DataType.KEYWORD, DataType.TEXT, DataType.BOOLEAN, DataType.DATETIME, DataType.DATE_NANOS, DataType.DOUBLE, DataType.INTEGER, DataType.IP, DataType.LONG, DataType.UNSIGNED_LONG, DataType.VERSION);
    public static final Set<DataType> QUERY_DATA_TYPES = Set.of(DataType.KEYWORD, DataType.BOOLEAN, DataType.DATETIME, DataType.DATE_NANOS, DataType.DOUBLE, DataType.INTEGER, DataType.IP, DataType.LONG, DataType.UNSIGNED_LONG, DataType.VERSION);
    protected final Expression field;
    private final transient Expression options;
    public static final Map<String, DataType> ALLOWED_OPTIONS = Map.ofEntries(Map.entry(MatchQueryBuilder.ANALYZER_FIELD.getPreferredName(), DataType.KEYWORD), Map.entry(MatchQueryBuilder.GENERATE_SYNONYMS_PHRASE_QUERY.getPreferredName(), DataType.BOOLEAN), Map.entry(Fuzziness.FIELD.getPreferredName(), DataType.KEYWORD), Map.entry(AbstractQueryBuilder.BOOST_FIELD.getPreferredName(), DataType.FLOAT), Map.entry(MatchQueryBuilder.FUZZY_TRANSPOSITIONS_FIELD.getPreferredName(), DataType.BOOLEAN), Map.entry(MatchQueryBuilder.FUZZY_REWRITE_FIELD.getPreferredName(), DataType.KEYWORD), Map.entry(MatchQueryBuilder.LENIENT_FIELD.getPreferredName(), DataType.BOOLEAN), Map.entry(MatchQueryBuilder.MAX_EXPANSIONS_FIELD.getPreferredName(), DataType.INTEGER), Map.entry(MatchQueryBuilder.MINIMUM_SHOULD_MATCH_FIELD.getPreferredName(), DataType.KEYWORD), Map.entry(MatchQueryBuilder.OPERATOR_FIELD.getPreferredName(), DataType.KEYWORD), Map.entry(MatchQueryBuilder.PREFIX_LENGTH_FIELD.getPreferredName(), DataType.INTEGER), Map.entry(MatchQueryBuilder.ZERO_TERMS_QUERY_FIELD.getPreferredName(), DataType.KEYWORD));

    @FunctionInfo(returnType={"boolean"}, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.PREVIEW, version="9.0.0"), @FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.GA, version="9.1.0")}, description="Use `MATCH` to perform a <<query-dsl-match-query,match query>> on the specified field.\nUsing `MATCH` is equivalent to using the `match` query in the Elasticsearch Query DSL.", detailedDescription="Match can be used on fields from the text family like <<text, text>> and <<semantic-text, semantic_text>>,\nas well as other field types like keyword, boolean, dates, and numeric types.\nWhen Match is used on a <<semantic-text, semantic_text>> field, it will perform a semantic query on the field.\n\nMatch can use <<esql-function-named-params,function named parameters>> to specify additional options\nfor the match query.\nAll <<match-field-params,match query parameters>> are supported.\n\nFor a simplified syntax, you can use the <<esql-match-operator,match operator>> `:` operator instead of `MATCH`.\n\n`MATCH` returns true if the provided query matches the row.", examples={@Example(file="match-function", tag="match-with-field"), @Example(file="match-function", tag="match-with-named-function-params")})
    public Match(Source source, @Param(name="field", type={"keyword", "text", "boolean", "date", "date_nanos", "double", "integer", "ip", "long", "unsigned_long", "version"}, description="Field that the query will target.") Expression field, @Param(name="query", type={"keyword", "boolean", "date", "date_nanos", "double", "integer", "ip", "long", "unsigned_long", "version"}, description="Value to find in the provided field.") Expression matchQuery, @MapParam(name="options", description="(Optional) Match additional options as <<esql-function-named-params,function named parameters>>.", params={@MapParam.MapParamEntry(name="analyzer", type={"keyword"}, valueHint={"standard"}, description="Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index\u2019s default analyzer is used."), @MapParam.MapParamEntry(name="auto_generate_synonyms_phrase_query", type={"boolean"}, valueHint={"true", "false"}, description="If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true."), @MapParam.MapParamEntry(name="fuzziness", type={"keyword"}, valueHint={"AUTO", "1", "2"}, description="Maximum edit distance allowed for matching."), @MapParam.MapParamEntry(name="boost", type={"float"}, valueHint={"2.5"}, description="Floating point number used to decrease or increase the relevance scores of the query. Defaults to 1.0."), @MapParam.MapParamEntry(name="fuzzy_transpositions", type={"boolean"}, valueHint={"true", "false"}, description="If true, edits for fuzzy matching include transpositions of two adjacent characters (ab \u2192 ba). Defaults to true."), @MapParam.MapParamEntry(name="fuzzy_rewrite", type={"keyword"}, valueHint={"constant_score_blended", "constant_score", "constant_score_boolean", "top_terms_blended_freqs_N", "top_terms_boost_N", "top_terms_N"}, description="Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default."), @MapParam.MapParamEntry(name="lenient", type={"boolean"}, valueHint={"true", "false"}, description="If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to false."), @MapParam.MapParamEntry(name="max_expansions", type={"integer"}, valueHint={"50"}, description="Maximum number of terms to which the query will expand. Defaults to 50."), @MapParam.MapParamEntry(name="minimum_should_match", type={"integer"}, valueHint={"2"}, description="Minimum number of clauses that must match for a document to be returned."), @MapParam.MapParamEntry(name="operator", type={"keyword"}, valueHint={"AND", "OR"}, description="Boolean logic used to interpret text in the query value. Defaults to OR."), @MapParam.MapParamEntry(name="prefix_length", type={"integer"}, valueHint={"1"}, description="Number of beginning characters left unchanged for fuzzy matching. Defaults to 0."), @MapParam.MapParamEntry(name="zero_terms_query", type={"keyword"}, valueHint={"none", "all"}, description="Indicates whether all documents or none are returned if the analyzer removes all tokens, such as when using a stop filter. Defaults to none.")}, optional=true) Expression options) {
        this(source, field, matchQuery, options, null);
    }

    public Match(Source source, Expression field, Expression matchQuery, Expression options, QueryBuilder queryBuilder) {
        super(source, matchQuery, options == null ? List.of(field, matchQuery) : List.of(field, matchQuery, options), queryBuilder);
        this.field = field;
        this.options = options;
    }

    public String getWriteableName() {
        return Match.ENTRY.name;
    }

    private static Match readFrom(StreamInput in) throws IOException {
        Source source = Source.readFrom((StreamInput)((PlanStreamInput)in));
        Expression field = (Expression)in.readNamedWriteable(Expression.class);
        Expression query = (Expression)in.readNamedWriteable(Expression.class);
        QueryBuilder queryBuilder = null;
        if (in.getTransportVersion().supports(TransportVersions.V_8_18_0)) {
            queryBuilder = (QueryBuilder)in.readOptionalNamedWriteable(QueryBuilder.class);
        }
        return new Match(source, field, query, null, queryBuilder);
    }

    public final void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.field());
        out.writeNamedWriteable((NamedWriteable)this.query());
        if (out.getTransportVersion().supports(TransportVersions.V_8_18_0)) {
            out.writeOptionalNamedWriteable((NamedWriteable)this.queryBuilder());
        }
    }

    @Override
    protected Expression.TypeResolution resolveParams() {
        return this.resolveField().and(this.resolveQuery()).and(Options.resolve(this.options(), this.source(), TypeResolutions.ParamOrdinal.THIRD, ALLOWED_OPTIONS)).and(this.checkParamCompatibility());
    }

    private Expression.TypeResolution resolveField() {
        return TypeResolutions.isNotNull((Expression)this.field, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST).and(TypeResolutions.isType((Expression)this.field, FIELD_DATA_TYPES::contains, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST, (String[])new String[]{"keyword, text, boolean, date, date_nanos, double, integer, ip, long, unsigned_long, version"}));
    }

    private Expression.TypeResolution resolveQuery() {
        Expression.TypeResolution result = TypeResolutions.isType((Expression)this.query(), QUERY_DATA_TYPES::contains, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND, (String[])new String[]{"keyword, boolean, date, date_nanos, double, integer, ip, long, unsigned_long, version"}).and(TypeResolutions.isNotNull((Expression)this.query(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND));
        if (result.unresolved()) {
            return result;
        }
        result = Foldables.resolveTypeQuery(this.query(), this.sourceText(), Foldables.TypeResolutionValidator.forPreOptimizationValidation(this.query()));
        if (!result.equals(Expression.TypeResolution.TYPE_RESOLVED)) {
            return result;
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    private Expression.TypeResolution checkParamCompatibility() {
        DataType queryType;
        DataType fieldType = this.field().dataType();
        if (fieldType == (queryType = this.query().dataType()) || queryType == DataType.KEYWORD) {
            return Expression.TypeResolution.TYPE_RESOLVED;
        }
        if (fieldType.isNumeric() && queryType.isNumeric() && !(queryType == DataType.UNSIGNED_LONG && fieldType != DataType.UNSIGNED_LONG)) {
            return Expression.TypeResolution.TYPE_RESOLVED;
        }
        return new Expression.TypeResolution(EsqlBinaryComparison.formatIncompatibleTypesMessage(fieldType, queryType, this.sourceText()));
    }

    private Map<String, Object> matchQueryOptions() throws InvalidArgumentException {
        if (this.options() == null) {
            return Map.of(MatchQueryBuilder.LENIENT_FIELD.getPreferredName(), true);
        }
        HashMap<String, Object> matchOptions = new HashMap<String, Object>();
        matchOptions.put(MatchQueryBuilder.LENIENT_FIELD.getPreferredName(), true);
        Options.populateMap((MapExpression)this.options(), matchOptions, this.source(), TypeResolutions.ParamOrdinal.SECOND, ALLOWED_OPTIONS);
        return matchOptions;
    }

    public Expression field() {
        return this.field;
    }

    public Expression options() {
        return this.options;
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Match::new, (Object)this.field(), (Object)this.query(), (Object)this.options(), (Object)this.queryBuilder());
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Match(this.source(), newChildren.get(0), newChildren.get(1), newChildren.size() > 2 ? newChildren.get(2) : null, this.queryBuilder());
    }

    @Override
    public Expression replaceQueryBuilder(QueryBuilder queryBuilder) {
        return new Match(this.source(), this.field, this.query(), this.options(), queryBuilder);
    }

    @Override
    public BiConsumer<LogicalPlan, Failures> postAnalysisPlanVerification() {
        return (plan, failures) -> {
            super.postAnalysisPlanVerification().accept((LogicalPlan)((Object)plan), (Failures)failures);
            Match.fieldVerifier(plan, this, this.field, failures);
        };
    }

    public Object queryAsObject() {
        Object queryAsObject = Foldables.queryAsObject(this.query(), this.sourceText());
        if (queryAsObject instanceof BytesRef) {
            BytesRef bytesRef = (BytesRef)queryAsObject;
            return switch (this.query().dataType()) {
                case DataType.IP -> EsqlDataTypeConverter.ipToString(bytesRef);
                case DataType.VERSION -> EsqlDataTypeConverter.versionToString(bytesRef);
                default -> bytesRef.utf8ToString();
            };
        }
        if (this.query().dataType() == DataType.UNSIGNED_LONG) {
            return NumericUtils.unsignedLongAsBigInteger((long)((Long)queryAsObject));
        }
        if (this.query().dataType() == DataType.DATETIME && queryAsObject instanceof Long) {
            return EsqlDataTypeConverter.dateTimeToString((Long)queryAsObject);
        }
        if (this.query().dataType() == DataType.DATE_NANOS && queryAsObject instanceof Long) {
            return EsqlDataTypeConverter.nanoTimeToString((Long)queryAsObject);
        }
        return queryAsObject;
    }

    @Override
    protected Query translate(LucenePushdownPredicates pushdownPredicates, TranslatorHandler handler) {
        FieldAttribute fieldAttribute = this.fieldAsFieldAttribute();
        Check.notNull((Object)fieldAttribute, (String)"Match must have a field attribute as the first argument");
        String fieldName = Match.getNameFromFieldAttribute(fieldAttribute);
        return new MatchQuery(this.source(), fieldName, this.queryAsObject(), this.matchQueryOptions());
    }

    private FieldAttribute fieldAsFieldAttribute() {
        return Match.fieldAsFieldAttribute(this.field);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Match match = (Match)o;
        return Objects.equals(this.field(), match.field()) && Objects.equals(this.query(), match.query()) && Objects.equals(this.queryBuilder(), match.queryBuilder());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field(), this.query(), this.queryBuilder());
    }
}

