/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.action;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;
import org.elasticsearch.Build;
import org.elasticsearch.common.util.FeatureFlag;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.xpack.esql.plugin.EsqlFeatures;

public class EsqlCapabilities {
    public static final Set<String> CAPABILITIES = EsqlCapabilities.capabilities(false);

    public static Set<String> capabilities(boolean all) {
        ArrayList<String> caps = new ArrayList<String>();
        for (Cap cap : Cap.values()) {
            if (!all && !cap.isEnabled()) continue;
            caps.add(cap.capabilityName());
        }
        for (NodeFeature feature : new EsqlFeatures().getFeatures()) {
            caps.add(EsqlCapabilities.cap(feature));
        }
        return Set.copyOf(caps);
    }

    public static String cap(NodeFeature feature) {
        assert (feature.id().startsWith("esql."));
        return feature.id().substring("esql.".length());
    }

    public static enum Cap {
        MV_SORT,
        DISABLE_NULLABLE_OPTS,
        ST_X_Y,
        SPATIAL_POINTS_FROM_SOURCE,
        SPATIAL_SHAPES,
        GEO_VALIDATION,
        ST_CENTROID_AGG,
        ST_INTERSECTS,
        ST_CONTAINS_WITHIN,
        ST_DISJOINT,
        AGG_VALUES,
        AGG_VALUES_SPATIAL,
        AGG_MAX_MIN_UNSIGNED_LONG,
        AGG_VALUES_SAMPLE_UNSIGNED_LONG,
        ASYNC_QUERY,
        FROM_OPTIONS,
        STRING_LITERAL_AUTO_CASTING,
        BASE64_DECODE_ENCODE,
        CASTING_OPERATOR,
        CASTING_OPERATOR_FOR_DATE,
        MV_ORDERING_SORTED_ASCENDING,
        METRICS_COUNTER_FIELDS,
        STRING_LITERAL_AUTO_CASTING_EXTENDED,
        METADATA_FIELDS,
        INDEX_METADATA_FIELD,
        TIMESPAN_ABBREVIATIONS,
        COUNTER_TYPES,
        FN_BIT_LENGTH,
        FN_BYTE_LENGTH,
        FN_REVERSE,
        FN_REVERSE_GRAPHEME_CLUSTERS,
        FN_CONTAINS,
        FN_CBRT,
        FN_HYPOT,
        FN_MV_APPEND,
        FN_MV_MEDIAN_ABSOLUTE_DEVIATION,
        FN_MV_PERCENTILE,
        FN_IP_PREFIX,
        FN_SUBSTRING_EMPTY_NULL,
        FN_ROUND_UL_FIXES,
        FN_SCALB,
        FN_DAY_NAME,
        FN_MONTH_NAME,
        FN_MV_CONTAINS_V1,
        FUNCTIONS_SOURCE_SERIALIZATION_WARNINGS,
        FUNCTIONS_NEVER_EMIT_TEXT,
        INLINESTATS,
        INLINESTATS_V2,
        AGG_TOP,
        AGG_MAX_MIN_BOOLEAN_SUPPORT,
        AGG_MAX_MIN_IP_SUPPORT,
        AGG_MAX_MIN_STRING_SUPPORT,
        AGG_TOP_BOOLEAN_SUPPORT,
        AGG_TOP_IP_SUPPORT,
        AGG_TOP_STRING_SUPPORT,
        AGG_TOP_WITH_OPTIONAL_ORDER_FIELD,
        CASE_MV,
        ENRICH_LOAD,
        ST_CENTROID_AGG_OPTIMIZED,
        METADATA_IGNORED_FIELD,
        LOOKUP_V4(Build.current().isSnapshot()),
        REPEAT,
        STRING_LITERAL_AUTO_CASTING_TO_DATETIME_ADD_SUB,
        IMPLICIT_CASTING_DATE_AND_DATE_NANOS,
        NAMED_POSITIONAL_PARAMETER,
        UNION_TYPES,
        UNMAPPED_FIELDS(Build.current().isSnapshot()),
        ST_DISTANCE,
        ST_EXTENT_AGG,
        ST_EXTENT_AGG_DOCVALUES,
        SPATIAL_FUNCTIONS_FIX_CRSTYPE_FOLDING,
        SPATIAL_PREDICATES_SUPPORT_MULTIVALUES,
        SPATIAL_DISTANCE_SUPPORTS_MULTIVALUES,
        SPATIAL_DISTANCE_PUSHDOWN_ENHANCEMENTS,
        SPATIAL_CENTROID_NO_RECORDS,
        ST_ENVELOPE,
        SPATIAL_GRID,
        SPATIAL_GRID_TYPES,
        SPATIAL_GRID_INTERSECTS,
        GROK_DISSECT_MASKING,
        DOUBLE_QUOTES_SOURCE_ENCLOSING,
        AGG_WEIGHTED_AVG,
        UNION_TYPES_AGG_CAST,
        FIX_COUNT_PUSHDOWN_FOR_UNION_TYPES,
        GROK_VALIDATION,
        UNION_TYPES_INLINE_FIX,
        UNION_TYPES_REMOVE_FIELDS,
        UNION_TYPES_FIX_RENAME_RESOLUTION,
        RENAME_SEQUENTIAL_PROCESSING,
        RENAME_ALLOW_ASSIGNMENT,
        REMOVE_EMPTY_ATTRIBUTE_IN_MERGING_OUTPUT,
        RETAIN_AGGREGATE_WHEN_GROUPING,
        UNION_TYPES_MISSING_FIELD,
        UNION_TYPES_NUMERIC_WIDENING,
        FIX_PARSING_LARGE_NEGATIVE_NUMBERS,
        FIX_PRECISION_OF_SCALED_FLOAT_FIELDS,
        FIX_COUNT_DISTINCT_SOURCE_ERROR,
        RANGEQUERY_FOR_DATETIME,
        ENRICH_STRICT_RANGE_TYPES,
        UNIQUE_NAMES,
        FIXED_PUSHDOWN_PAST_PROJECT,
        FIXED_PUSHDOWN_PAST_PROJECT_WITH_ATTRIBUTES_RESOLUTION,
        MV_PSERIES_WEIGHTED_SUM,
        MATCH_OPERATOR_COLON,
        NO_META,
        COMBINE_BINARY_COMPARISONS,
        DATE_NANOS_TYPE,
        TO_DATE_NANOS,
        DATE_NANOS_BINARY_COMPARISON,
        DATE_NANOS_COMPARE_TO_MILLIS,
        DATE_NANOS_IMPLICIT_CASTING,
        LEAST_GREATEST_FOR_DATENANOS,
        DATE_NANOS_DATE_EXTRACT,
        DATE_NANOS_ADD_SUBTRACT,
        DATE_TRUNC_DATE_NANOS,
        DATE_NANOS_BUCKET,
        DATE_NANOS_AGGREGATIONS,
        DATE_NANOS_IN_OPERATOR,
        DATE_NANOS_DATE_FORMAT,
        DATE_NANOS_DATE_DIFF,
        FIX_DATE_NANOS_LUCENE_PUSHDOWN_BUG,
        FIX_DATE_NANOS_MIXED_RANGE_PUSHDOWN_BUG,
        DATE_NANOS_LOOKUP_JOIN,
        DATE_PARSE_TZ,
        LEAST_GREATEST_FOR_DATES,
        COMBINE_DISJUNCTIVE_CIDRMATCHES,
        ASYNC_QUERY_STATUS_HEADERS,
        ASYNC_QUERY_STATUS_HEADERS_FIX,
        BUCKET_INCLUSIVE_UPPER_BOUND,
        DATE_TRUNC_WITH_ARBITRARY_INTERVALS,
        SHORT_ERROR_MESSAGES_FOR_UNSUPPORTED_FIELDS,
        BUCKET_WHOLE_NUMBER_AS_SPAN,
        MIXED_NUMERIC_TYPES_IN_COALESCE,
        SPACE,
        CAST_STRING_LITERAL_TO_TEMPORAL_AMOUNT,
        CATEGORIZE_V6,
        CATEGORIZE_MULTIPLE_GROUPINGS,
        QSTR_FUNCTION,
        MATCH_FUNCTION,
        KQL_FUNCTION,
        KQL_FUNCTION_OPTIONS,
        HASH_FUNCTION,
        HASH_FUNCTION_ALIASES_V1,
        FIXED_WRONG_IS_NOT_NULL_CHECK_ON_CASE,
        DATE_DIFF_YEAR_CALENDARIAL,
        SORTING_ON_SOURCE_AND_COUNTERS_FORBIDDEN,
        SORT_RETURNING_SOURCE_OK,
        SOURCE_FIELD_MAPPING,
        PER_AGG_FILTERING,
        PER_AGG_FILTERING_ORDS,
        STD_DEV,
        FIX_STATS_BY_FOLDABLE_EXPRESSION,
        FUNCTION_STATS,
        FIX_FILTER_PUSHDOWN_PAST_STATS,
        STATS_ALIAS_COLLISION_WARNINGS,
        SNAPSHOT_TEST_FOR_TELEMETRY_V2(Build.current().isSnapshot()),
        NON_SNAPSHOT_TEST_FOR_TELEMETRY_V2(!Build.current().isSnapshot()),
        NAMED_PARAMETER_FOR_FIELD_AND_FUNCTION_NAMES_SIMPLIFIED_SYNTAX,
        ADD_LIMIT_INSIDE_MV_EXPAND,
        DELAY_DEBUG_FN(Build.current().isSnapshot()),
        METADATA_FIELDS_REMOTE_TEST(false),
        JOIN_PLANNING_V1(Build.current().isSnapshot()),
        IMPLICIT_CASTING_STRING_LITERAL_TO_TEMPORAL_AMOUNT,
        JOIN_LOOKUP_V12,
        LOOKUP_JOIN_TEXT(JOIN_LOOKUP_V12.isEnabled()),
        JOIN_LOOKUP_SKIP_MV_WARNINGS(JOIN_LOOKUP_V12.isEnabled()),
        ASYNC_OPERATOR_WARNINGS_FIX,
        JOIN_LOOKUP_FIX_LIMIT_PUSHDOWN(JOIN_LOOKUP_V12.isEnabled()),
        FIX_NESTED_FIELDS_NAME_CLASH_IN_INDEXRESOLVER,
        FIX_STATS_BY_FOLDABLE_EXPRESSION_2,
        METADATA_SCORE,
        TERM_FUNCTION(Build.current().isSnapshot()),
        MATCH_ADDITIONAL_TYPES,
        FIXED_REGEX_FOLD,
        FULL_TEXT_FUNCTIONS_DISJUNCTIONS,
        SEMANTIC_TEXT_FIELD_CAPS,
        OPTIONAL_NAMED_ARGUMENT_MAP_FOR_FUNCTION(Build.current().isSnapshot()),
        LOOKUP_JOIN_NO_ALIASES(JOIN_LOOKUP_V12.isEnabled()),
        FULL_TEXT_FUNCTIONS_DISJUNCTIONS_COMPUTE_ENGINE,
        MATCH_FUNCTION_OPTIONS,
        QUERY_STRING_FUNCTION_OPTIONS,
        AGGREGATE_METRIC_DOUBLE_V0,
        CHANGE_POINT,
        REMOVE_REDUNDANT_SORT,
        INLINESTATS_V11,
        INLINE_STATS,
        SUPPORT_PARTIAL_RESULTS,
        RERANK,
        COMPLETION,
        MIXED_NUMERIC_TYPES_IN_CASE_GREATEST_LEAST,
        STARTS_WITH_ENDS_WITH_LUCENE_PUSHDOWN,
        FULL_TEXT_FUNCTIONS_DISJUNCTIONS_SCORE,
        MULTI_MATCH_FUNCTION(Build.current().isSnapshot()),
        TO_LOWER_MV,
        DOUBLE_PARAMETER_MARKERS_FOR_IDENTIFIERS,
        NON_FULL_TEXT_FUNCTIONS_SCORING,
        REPORT_ORIGINAL_TYPES,
        METRICS_COMMAND(Build.current().isSnapshot()),
        DOCUMENTS_FOUND_AND_VALUES_LOADED,
        INDEX_COMPONENT_SELECTORS,
        MAKE_NUMBER_OF_CHANNELS_CONSISTENT_WITH_LAYOUT,
        FIX_REPLACE_MISSING_FIELD_WITH_NULL_DUPLICATE_NAME_ID_IN_LAYOUT,
        FILTER_IN_CONVERTED_NULL,
        FIX_DOUBLY_RELEASED_NULL_BLOCKS_IN_VALUESOURCEREADER,
        QUERY_MONITORING,
        FORK_V9,
        FORK_UNION_TYPES,
        TO_IP_LEADING_ZEROS,
        USAGE_CONTAINS_TOOK,
        LOADING_NON_INDEXED_IP_FIELDS,
        FIX_JOIN_MASKING_EVAL,
        DROP_AGAIN_WITH_WILDCARD_AFTER_EVAL,
        DROP_WITH_WILDCARD_AFTER_LOOKUP_JOIN,
        SCORE_FUNCTION(Build.current().isSnapshot()),
        SAMPLE_V3,
        SUGGESTED_CAST,
        TO_LOWER_EMPTY_STRING,
        INCREASE,
        DELTA_TS_AGG,
        CLAMP_FUNCTIONS,
        RESOLVE_GROUPINGS_BEFORE_RESOLVING_REFERENCES_TO_GROUPINGS_IN_AGGREGATIONS,
        AGG_SAMPLE,
        FULL_TEXT_FUNCTIONS_IN_STATS_WHERE,
        FIX_JOIN_MASKING_REGEX_EXTRACT,
        FIX_JOIN_OUTPUT_MERGING,
        KEEP_REGEX_EXTRACT_ATTRIBUTES,
        ROUND_TO,
        COPY_SIGN,
        LOOKUP_JOIN_ON_MIXED_NUMERIC_FIELDS,
        LUCENE_QUERY_EVALUATOR_QUERY_REWRITE,
        PARAMETER_FOR_LIMIT,
        NORMALIZED_LIMIT_ERROR_MESSAGE,
        DENSE_VECTOR_FIELD_TYPE_RELEASED,
        ENABLE_LOOKUP_JOIN_ON_ALIASES,
        UPDATE_LOOKUP_JOIN_ERROR_MESSAGES,
        RLIKE_WITH_EMPTY_LANGUAGE_PATTERN,
        ENABLE_LOOKUP_JOIN_ON_REMOTE,
        REMOTE_ENRICH_AFTER_LOOKUP_JOIN,
        MATCH_PHRASE_FUNCTION,
        KNN_FUNCTION_V5,
        TEXT_EMBEDDING_FUNCTION,
        LIKE_WITH_LIST_OF_PATTERNS,
        LIKE_LIST_ON_INDEX_FIELDS,
        PARAMETER_FOR_SAMPLE,
        NO_PLAIN_STRINGS_IN_LITERALS,
        FIX_MV_EXPAND_INCONSISTENT_COLUMN_ORDER,
        SET_COMMAND(Build.current().isSnapshot()),
        EXPLAIN(Build.current().isSnapshot()),
        RLIKE_WITH_LIST_OF_PATTERNS,
        FUSE_V6,
        LIKE_ON_INDEX_FIELDS,
        NO_BRACKETS_IN_UNQUOTED_INDEX_NAMES,
        COSINE_VECTOR_SIMILARITY_FUNCTION(Build.current().isSnapshot()),
        FIXED_PROFILE_SERIALIZATION,
        LOOKUP_JOIN_ON_MULTIPLE_FIELDS,
        DOT_PRODUCT_VECTOR_SIMILARITY_FUNCTION(Build.current().isSnapshot()),
        L1_NORM_VECTOR_SIMILARITY_FUNCTION(Build.current().isSnapshot()),
        L2_NORM_VECTOR_SIMILARITY_FUNCTION(Build.current().isSnapshot()),
        CATEGORIZE_OPTIONS,
        DECAY_FUNCTION(Build.current().isSnapshot()),
        AGG_FIRST_LAST(Build.current().isSnapshot()),
        AGG_FIRST_LAST_STRING(Build.current().isSnapshot()),
        CORRECT_SKIPPED_SHARDS_COUNT,
        MAGNITUDE_SCALAR_VECTOR_FUNCTION(Build.current().isSnapshot()),
        DENSE_VECTOR_FIELD_TYPE_BYTE_ELEMENTS,
        DENSE_VECTOR_FIELD_TYPE_BIT_ELEMENTS,
        VECTOR_SIMILARITY_FUNCTIONS_SUPPORT_NULL,
        HAMMING_VECTOR_SIMILARITY_FUNCTION(Build.current().isSnapshot()),
        TBUCKET,
        NAME_QUALIFIERS(Build.current().isSnapshot()),
        URL_ENCODE,
        URL_ENCODE_COMPONENT,
        URL_DECODE,
        LOOKUP_JOIN_ON_BOOLEAN_EXPRESSION,
        LOOKUP_JOIN_WITH_FULL_TEXT_FUNCTION,
        ENABLE_FORK_FOR_REMOTE_INDICES(Build.current().isSnapshot()),
        FN_PRESENT,
        STATS_WITH_FILTERED_SURROGATE_FIXED,
        TO_DENSE_VECTOR_FUNCTION,
        QUERY_PARAMS_MULTI_VALUES,
        FIX_PERCENTILE_PRECISION,
        FN_ABSENT,
        INLINE_STATS_SUPPORTS_REMOTE(Cap.INLINESTATS_V11.enabled),
        INLINE_STATS_WITH_UNION_TYPES_IN_STUB_RELATION(Cap.INLINE_STATS.enabled),
        TS_COMMAND_V0,
        FIRST_LAST_OVER_TIME_COUNTER_SUPPORT,
        FIX_ALIAS_ID_WHEN_DROP_ALL_AGGREGATES,
        PERCENTILE_OVER_TIME,
        INLINE_STATS_FIX_PRUNING_NULL_FILTER(Cap.INLINESTATS_V11.enabled),
        INLINE_STATS_FIX_OPTIMIZED_AS_LOCAL_RELATION(Cap.INLINESTATS_V11.enabled),
        DENSE_VECTOR_AGG_METRIC_DOUBLE_IF_FNS,
        DENSE_VECTOR_AGG_METRIC_DOUBLE_IF_VERSION,
        FUSE_L2_NORM(Build.current().isSnapshot()),
        METADATA_TSID_FIELD,
        TS_PERMIT_TEXT_BECOMING_KEYWORD_WHEN_GROUPED_ON,
        FIX_NO_COLUMNS,
        DOTS_IN_FUSE,
        NETWORK_DIRECTION(Build.current().isSnapshot()),
        TEMPORAL_AMOUNT_M,
        PACK_DIMENSIONS_IN_TS,
        FIX_FILTER_ORDINALS,
        GROK_MULTI_PATTERN,
        INLINE_STATS_PRUNE_COLUMN_FIX(Cap.INLINESTATS.enabled),
        INLINE_STATS_DOUBLE_RELEASE_FIX(Cap.INLINESTATS_V11.enabled),
        PUSHING_DOWN_EVAL_WITH_SCORE,
        ATTRIBUTE_EQUALS_RESPECTS_NAME_ID,
        LOOKUP_JOIN_SEMANTIC_FILTER_DEDUP,
        FORBID_LIMIT_BEFORE_INLINE_STATS(Cap.INLINE_STATS.enabled),
        FN_TRANGE;

        private final boolean enabled;

        private Cap() {
            this.enabled = true;
        }

        private Cap(boolean enabled) {
            this.enabled = enabled;
        }

        private Cap(FeatureFlag featureFlag) {
            this.enabled = featureFlag.isEnabled();
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String capabilityName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

