/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BytesRefHash;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.bucket.terms.LongKeyedBucketOrds;

public abstract class BytesKeyedBucketOrds
implements Releasable {
    public static BytesKeyedBucketOrds build(BigArrays bigArrays, CardinalityUpperBound cardinality) {
        return cardinality.map(estimate -> estimate < 2 ? new FromSingle(bigArrays) : new FromMany(bigArrays));
    }

    private BytesKeyedBucketOrds() {
    }

    public abstract long add(long var1, BytesRef var3);

    public abstract long bucketsInOrd(long var1);

    public abstract long size();

    public abstract BucketOrdsEnum ordsEnum(long var1);

    private static class FromSingle
    extends BytesKeyedBucketOrds {
        private final BytesRefHash ords;

        private FromSingle(BigArrays bigArrays) {
            this.ords = new BytesRefHash(1L, bigArrays);
        }

        @Override
        public long add(long owningBucketOrd, BytesRef value) {
            assert (owningBucketOrd == 0L);
            return this.ords.add(value);
        }

        @Override
        public long bucketsInOrd(long owningBucketOrd) {
            return this.ords.size();
        }

        @Override
        public long size() {
            return this.ords.size();
        }

        @Override
        public BucketOrdsEnum ordsEnum(long owningBucketOrd) {
            return new BucketOrdsEnum(){
                private int ord = -1;

                @Override
                public boolean next() {
                    ++this.ord;
                    return (long)this.ord < ords.size();
                }

                @Override
                public long ord() {
                    return this.ord;
                }

                @Override
                public void readValue(BytesRef dest) {
                    ords.get(this.ord, dest);
                }
            };
        }

        public void close() {
            this.ords.close();
        }
    }

    private static class FromMany
    extends BytesKeyedBucketOrds {
        private final BytesRefHash bytesToLong;
        private final LongKeyedBucketOrds longToBucketOrds;

        private FromMany(BigArrays bigArrays) {
            this.bytesToLong = new BytesRefHash(1L, bigArrays);
            boolean success = false;
            try {
                this.longToBucketOrds = LongKeyedBucketOrds.build(bigArrays, CardinalityUpperBound.MANY);
                success = true;
            }
            finally {
                if (!success) {
                    this.close();
                }
            }
        }

        @Override
        public long add(long owningBucketOrd, BytesRef value) {
            long l = this.bytesToLong.add(value);
            if (l < 0L) {
                l = -1L - l;
            }
            return this.longToBucketOrds.add(owningBucketOrd, l);
        }

        @Override
        public long bucketsInOrd(long owningBucketOrd) {
            return this.longToBucketOrds.bucketsInOrd(owningBucketOrd);
        }

        @Override
        public long size() {
            return this.longToBucketOrds.size();
        }

        @Override
        public BucketOrdsEnum ordsEnum(long owningBucketOrd) {
            final LongKeyedBucketOrds.BucketOrdsEnum delegate = this.longToBucketOrds.ordsEnum(owningBucketOrd);
            return new BucketOrdsEnum(){

                @Override
                public boolean next() {
                    return delegate.next();
                }

                @Override
                public long ord() {
                    return delegate.ord();
                }

                @Override
                public void readValue(BytesRef dest) {
                    bytesToLong.get(delegate.value(), dest);
                }
            };
        }

        public void close() {
            Releasables.close((Releasable[])new Releasable[]{this.bytesToLong, this.longToBucketOrds});
        }
    }

    public static interface BucketOrdsEnum {
        public boolean next();

        public long ord();

        public void readValue(BytesRef var1);
    }
}

