/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import org.elasticsearch.action.support.local.TransportLocalClusterStateAction;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.RestRequest;

public class RestUtils {
    private static final boolean DECODE_PLUS_AS_SPACE = Booleans.parseBoolean((String)System.getProperty("es.rest.url_plus_as_space", "false"));
    public static final UnaryOperator<String> REST_DECODER = RestUtils::decodeComponent;
    public static final String REST_MASTER_TIMEOUT_PARAM = "master_timeout";
    public static final TimeValue REST_MASTER_TIMEOUT_DEFAULT = TimeValue.timeValueSeconds((long)30L);
    public static final String REST_TIMEOUT_PARAM = "timeout";
    public static final String INCLUDE_SOURCE_ON_ERROR_PARAMETER = "include_source_on_error";

    public static void decodeQueryString(URI uri, Map<String, String> params) {
        String rawQuery = uri.getRawQuery();
        if (Strings.hasLength(rawQuery)) {
            RestUtils.decodeQueryString(rawQuery, 0, params);
        }
    }

    public static void decodeQueryString(String s, int fromIndex, Map<String, String> params) {
        int i;
        if (fromIndex < 0) {
            return;
        }
        if (fromIndex >= s.length()) {
            return;
        }
        int queryStringLength = s.contains("#") ? s.indexOf(35) : s.length();
        String name = null;
        int pos = fromIndex;
        char c = '\u0000';
        for (i = fromIndex; i < queryStringLength; ++i) {
            c = s.charAt(i);
            if (c == '=' && name == null) {
                if (pos != i) {
                    name = RestUtils.decodeQueryStringParam(s.substring(pos, i));
                }
                pos = i + 1;
                continue;
            }
            if (c != '&' && c != ';') continue;
            if (name == null && pos != i) {
                RestUtils.addParam(params, RestUtils.decodeQueryStringParam(s.substring(pos, i)), "");
            } else if (name != null) {
                RestUtils.addParam(params, name, RestUtils.decodeQueryStringParam(s.substring(pos, i)));
                name = null;
            }
            pos = i + 1;
        }
        if (pos != i) {
            if (name == null) {
                RestUtils.addParam(params, RestUtils.decodeQueryStringParam(s.substring(pos, i)), "");
            } else {
                RestUtils.addParam(params, name, RestUtils.decodeQueryStringParam(s.substring(pos, i)));
            }
        } else if (name != null) {
            RestUtils.addParam(params, name, "");
        }
    }

    private static String decodeQueryStringParam(String s) {
        return RestUtils.decodeComponent(s, StandardCharsets.UTF_8, true);
    }

    private static void addParam(Map<String, String> params, String name, String value) {
        for (String reservedParameter : RestRequest.INTERNAL_MARKER_REQUEST_PARAMETERS) {
            if (!reservedParameter.equalsIgnoreCase(name)) continue;
            throw new IllegalArgumentException("parameter [" + name + "] is reserved and may not be set");
        }
        params.put(name, value);
    }

    public static String decodeComponent(String s) {
        return RestUtils.decodeComponent(s, StandardCharsets.UTF_8, DECODE_PLUS_AS_SPACE);
    }

    private static String decodeComponent(String s, Charset charset, boolean plusAsSpace) {
        if (s == null) {
            return "";
        }
        int size = s.length();
        if (!RestUtils.decodingNeeded(s, size, plusAsSpace)) {
            return s;
        }
        byte[] buf = new byte[size];
        int pos = RestUtils.decode(s, size, buf, plusAsSpace);
        return new String(buf, 0, pos, charset);
    }

    private static boolean decodingNeeded(String s, int size, boolean plusAsSpace) {
        if (Strings.isEmpty(s)) {
            return false;
        }
        int num = Math.min(s.length(), size);
        for (int i = 0; i < num; ++i) {
            char c = s.charAt(i);
            if (c != '%' && (!plusAsSpace || c != '+')) continue;
            return true;
        }
        return false;
    }

    private static int decode(String s, int size, byte[] buf, boolean plusAsSpace) {
        int pos = 0;
        block4: for (int i = 0; i < size; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    buf[pos++] = (byte)(plusAsSpace ? 32 : 43);
                    continue block4;
                }
                case '%': {
                    if (i == size - 1) {
                        throw new IllegalArgumentException("unterminated escape sequence at end of string: " + s);
                    }
                    if ((c = s.charAt(++i)) == '%') {
                        buf[pos++] = 37;
                        continue block4;
                    }
                    if (i == size - 1) {
                        throw new IllegalArgumentException("partial escape sequence at end of string: " + s);
                    }
                    c = RestUtils.decodeHexNibble(c);
                    char c2 = RestUtils.decodeHexNibble(s.charAt(++i));
                    if (c == '\uffff' || c2 == '\uffff') {
                        throw new IllegalArgumentException("invalid escape sequence `%" + s.charAt(i - 1) + s.charAt(i) + "' at index " + (i - 2) + " of: " + s);
                    }
                    c = (char)(c * 16 + c2);
                }
                default: {
                    buf[pos++] = (byte)c;
                }
            }
        }
        return pos;
    }

    private static char decodeHexNibble(char c) {
        if ('0' <= c && c <= '9') {
            return (char)(c - 48);
        }
        if ('a' <= c && c <= 'f') {
            return (char)(c - 97 + 10);
        }
        if ('A' <= c && c <= 'F') {
            return (char)(c - 65 + 10);
        }
        return '\uffff';
    }

    public static Pattern checkCorsSettingForRegex(String corsSetting) {
        boolean isRegex;
        if (corsSetting == null) {
            return null;
        }
        int len = corsSetting.length();
        boolean bl = isRegex = len > 2 && corsSetting.startsWith("/") && corsSetting.endsWith("/");
        if (isRegex) {
            return Pattern.compile(corsSetting.substring(1, corsSetting.length() - 1));
        }
        return null;
    }

    public static String[] corsSettingAsArray(String corsSetting) {
        if (Strings.isNullOrEmpty(corsSetting)) {
            return new String[0];
        }
        return (String[])Arrays.stream(corsSetting.split(",")).map(String::trim).toArray(String[]::new);
    }

    public static Optional<String> extractTraceId(String traceparent) {
        return traceparent != null && traceparent.length() >= 55 ? Optional.of(traceparent.substring(3, 35)) : Optional.empty();
    }

    public static TimeValue getMasterNodeTimeout(RestRequest restRequest) {
        assert (restRequest != null);
        return restRequest.paramAsTime(REST_MASTER_TIMEOUT_PARAM, REST_MASTER_TIMEOUT_DEFAULT);
    }

    public static TimeValue getAckTimeout(RestRequest restRequest) {
        assert (restRequest != null);
        return restRequest.paramAsTime(REST_TIMEOUT_PARAM, AcknowledgedRequest.DEFAULT_ACK_TIMEOUT);
    }

    @Nullable
    public static TimeValue getTimeout(RestRequest restRequest) {
        assert (restRequest != null);
        return restRequest.paramAsTime(REST_TIMEOUT_PARAM, null);
    }

    public static boolean getIncludeSourceOnError(RestRequest restRequest) {
        assert (restRequest != null);
        return restRequest.paramAsBoolean(INCLUDE_SOURCE_ON_ERROR_PARAMETER, true);
    }

    public static void consumeDeprecatedLocalParameter(RestRequest request) {
        if (!request.hasParam("local")) {
            return;
        }
        boolean local = request.paramAsBoolean("local", false);
        if (request.getRestApiVersion() != RestApiVersion.V_8) {
            DeprecationLogger.getLogger(TransportLocalClusterStateAction.class).critical(DeprecationCategory.API, "TransportLocalClusterStateAction-local-parameter", "the [?local] query parameter to this API has no effect, is now deprecated, and will be removed in a future version", new Object[0]);
        }
    }
}

