/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.persistent;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasks;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.tasks.TaskId;

public abstract class PersistentTasksExecutor<Params extends PersistentTaskParams> {
    private final Executor executor;
    private final String taskName;
    public static final PersistentTasksCustomMetadata.Assignment NO_NODE_FOUND = new PersistentTasksCustomMetadata.Assignment(null, "no appropriate nodes found for the assignment");

    protected PersistentTasksExecutor(String taskName, Executor executor) {
        this.taskName = taskName;
        this.executor = executor;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public Scope scope() {
        return Scope.PROJECT;
    }

    public final PersistentTasksCustomMetadata.Assignment getAssignment(Params params, Collection<DiscoveryNode> candidateNodes, ClusterState clusterState, @Nullable ProjectId projectId) {
        assert (this.scope() == Scope.PROJECT && projectId != null || this.scope() == Scope.CLUSTER && projectId == null) : "inconsistent project-id [" + String.valueOf(projectId) + "] and task scope [" + String.valueOf((Object)this.scope()) + "]";
        return this.doGetAssignment(params, candidateNodes, clusterState, projectId);
    }

    protected PersistentTasksCustomMetadata.Assignment doGetAssignment(Params params, Collection<DiscoveryNode> candidateNodes, ClusterState clusterState, @Nullable ProjectId projectId) {
        DiscoveryNode discoveryNode = this.selectLeastLoadedNode(clusterState, candidateNodes, DiscoveryNode::canContainData);
        if (discoveryNode == null) {
            return NO_NODE_FOUND;
        }
        return new PersistentTasksCustomMetadata.Assignment(discoveryNode.getId(), "");
    }

    protected DiscoveryNode selectLeastLoadedNode(ClusterState clusterState, Collection<DiscoveryNode> candidateNodes, Predicate<DiscoveryNode> selector) {
        long minLoad = Long.MAX_VALUE;
        DiscoveryNode minLoadedNode = null;
        List<PersistentTasks> allPersistentTasks = PersistentTasks.getAllTasks(clusterState).map(Tuple::v2).toList();
        for (DiscoveryNode node : candidateNodes) {
            if (!selector.test(node)) continue;
            if (allPersistentTasks.isEmpty()) {
                return node;
            }
            long numberOfTasks = allPersistentTasks.stream().mapToLong(p -> p.getNumberOfTasksOnNode(node.getId(), this.taskName)).sum();
            if (minLoad <= numberOfTasks) continue;
            minLoad = numberOfTasks;
            minLoadedNode = node;
        }
        return minLoadedNode;
    }

    public void validate(Params params, ClusterState clusterState, @Nullable ProjectId projectId) {
    }

    protected AllocatedPersistentTask createTask(long id, String type, String action, TaskId parentTaskId, PersistentTasksCustomMetadata.PersistentTask<Params> taskInProgress, Map<String, String> headers) {
        return new AllocatedPersistentTask(id, type, action, this.getDescription(taskInProgress), parentTaskId, headers);
    }

    protected String getDescription(PersistentTasksCustomMetadata.PersistentTask<Params> taskInProgress) {
        return "id=" + taskInProgress.getId();
    }

    protected abstract void nodeOperation(AllocatedPersistentTask var1, Params var2, @Nullable PersistentTaskState var3);

    public Executor getExecutor() {
        return this.executor;
    }

    public static enum Scope {
        PROJECT,
        CLUSTER;

    }
}

