/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.stats;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.search.SearchRequestAttributesExtractor;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.shard.SearchOperationListener;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.telemetry.metric.LongHistogram;
import org.elasticsearch.telemetry.metric.MeterRegistry;

public final class ShardSearchPhaseAPMMetrics
implements SearchOperationListener {
    public static final String DFS_SEARCH_PHASE_METRIC = "es.search.shards.phases.dfs.duration.histogram";
    public static final String QUERY_SEARCH_PHASE_METRIC = "es.search.shards.phases.query.duration.histogram";
    public static final String FETCH_SEARCH_PHASE_METRIC = "es.search.shards.phases.fetch.duration.histogram";
    private final LongHistogram dfsPhaseMetric;
    private final LongHistogram queryPhaseMetric;
    private final LongHistogram fetchPhaseMetric;

    public ShardSearchPhaseAPMMetrics(MeterRegistry meterRegistry) {
        this.dfsPhaseMetric = meterRegistry.registerLongHistogram(DFS_SEARCH_PHASE_METRIC, "DFS search phase execution times at the shard level, expressed as a histogram", "ms");
        this.queryPhaseMetric = meterRegistry.registerLongHistogram(QUERY_SEARCH_PHASE_METRIC, "Query search phase execution times at the shard level, expressed as a histogram", "ms");
        this.fetchPhaseMetric = meterRegistry.registerLongHistogram(FETCH_SEARCH_PHASE_METRIC, "Fetch search phase execution times at the shard level, expressed as a histogram", "ms");
    }

    @Override
    public void onDfsPhase(SearchContext searchContext, long tookInNanos) {
        ShardSearchPhaseAPMMetrics.recordPhaseLatency(this.dfsPhaseMetric, tookInNanos);
    }

    @Override
    public void onQueryPhase(SearchContext searchContext, long tookInNanos) {
        SearchExecutionContext searchExecutionContext = searchContext.getSearchExecutionContext();
        Long timeRangeFilterFromMillis = searchExecutionContext.getTimeRangeFilterFromMillis();
        ShardSearchPhaseAPMMetrics.recordPhaseLatency(this.queryPhaseMetric, tookInNanos, searchContext.request(), timeRangeFilterFromMillis);
    }

    @Override
    public void onFetchPhase(SearchContext searchContext, long tookInNanos) {
        SearchExecutionContext searchExecutionContext = searchContext.getSearchExecutionContext();
        Long timeRangeFilterFromMillis = searchExecutionContext.getTimeRangeFilterFromMillis();
        ShardSearchPhaseAPMMetrics.recordPhaseLatency(this.fetchPhaseMetric, tookInNanos, searchContext.request(), timeRangeFilterFromMillis);
    }

    private static void recordPhaseLatency(LongHistogram histogramMetric, long tookInNanos) {
        histogramMetric.record(TimeUnit.NANOSECONDS.toMillis(tookInNanos));
    }

    private static void recordPhaseLatency(LongHistogram histogramMetric, long tookInNanos, ShardSearchRequest request, Long timeRangeFilterFromMillis) {
        Map<String, Object> attributes = SearchRequestAttributesExtractor.extractAttributes(request, timeRangeFilterFromMillis, request.nowInMillis());
        histogramMetric.record(TimeUnit.NANOSECONDS.toMillis(tookInNanos), attributes);
    }
}

