/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.LongSupplier;
import org.apache.lucene.search.Query;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.ConstantFieldType;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.shard.IndexLongFieldRange;
import org.elasticsearch.indices.DateFieldRangeInfo;
import org.elasticsearch.xcontent.XContentParserConfiguration;

public class CoordinatorRewriteContext
extends QueryRewriteContext {
    public static final String TIER_FIELD_NAME = "_tier";
    public static final Set<String> SUPPORTED_FIELDS = Set.of("@timestamp", "event.ingested", "_tier", "_index");
    static final ConstantFieldType TIER_FIELD_TYPE = new ConstantFieldType("_tier", Map.of()){

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            throw new UnsupportedOperationException("fetching field values is not supported on the coordinator node");
        }

        @Override
        public String typeName() {
            return CoordinatorRewriteContext.TIER_FIELD_NAME;
        }

        @Override
        protected boolean matches(String pattern, boolean caseInsensitive, QueryRewriteContext context) {
            String tierPreference;
            if (caseInsensitive) {
                pattern = Strings.toLowercaseAscii(pattern);
            }
            if ((tierPreference = context.getTierPreference()) == null) {
                return false;
            }
            return Regex.simpleMatch(pattern, tierPreference);
        }

        @Override
        public String getConstantFieldValue(SearchExecutionContext context) {
            return context.getTierPreference();
        }

        @Override
        public Query existsQuery(SearchExecutionContext context) {
            throw new UnsupportedOperationException("field exists query is not supported on the coordinator node");
        }
    };
    @Nullable
    private final DateFieldRangeInfo dateFieldRangeInfo;
    private final String tier;

    public CoordinatorRewriteContext(XContentParserConfiguration parserConfig, Client client, LongSupplier nowInMillis, @Nullable DateFieldRangeInfo dateFieldRangeInfo, String tier) {
        super(parserConfig, client, nowInMillis, null, MappingLookup.EMPTY, Collections.emptyMap(), null, null, null, null, null, null, null, null, null, null, null, null, null, false);
        this.dateFieldRangeInfo = dateFieldRangeInfo;
        this.tier = tier;
    }

    @Override
    @Nullable
    public MappedFieldType getFieldType(String fieldName) {
        if (this.dateFieldRangeInfo != null && "@timestamp".equals(fieldName)) {
            return this.dateFieldRangeInfo.timestampFieldType();
        }
        if (this.dateFieldRangeInfo != null && "event.ingested".equals(fieldName)) {
            return this.dateFieldRangeInfo.eventIngestedFieldType();
        }
        if (TIER_FIELD_NAME.equals(fieldName)) {
            return TIER_FIELD_TYPE;
        }
        return null;
    }

    @Nullable
    public IndexLongFieldRange getFieldRange(String fieldName) {
        if (this.dateFieldRangeInfo != null && "@timestamp".equals(fieldName)) {
            return this.dateFieldRangeInfo.timestampRange();
        }
        if (this.dateFieldRangeInfo != null && "event.ingested".equals(fieldName)) {
            return this.dateFieldRangeInfo.eventIngestedRange();
        }
        return null;
    }

    @Override
    public CoordinatorRewriteContext convertToCoordinatorRewriteContext() {
        return this;
    }

    @Override
    public String getTierPreference() {
        return !this.tier.isEmpty() ? this.tier : null;
    }
}

