/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.blockloader.docvalues;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.blockloader.docvalues.BlockDocValuesReader;

public class IntsBlockLoader
extends BlockDocValuesReader.DocValuesBlockLoader {
    private final String fieldName;

    public IntsBlockLoader(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
        return factory.ints(expectedCount);
    }

    @Override
    public BlockLoader.AllReader reader(LeafReaderContext context) throws IOException {
        SortedNumericDocValues docValues = context.reader().getSortedNumericDocValues(this.fieldName);
        if (docValues != null) {
            NumericDocValues singleton = DocValues.unwrapSingleton((SortedNumericDocValues)docValues);
            if (singleton != null) {
                return new SingletonInts(singleton);
            }
            return new Ints(docValues);
        }
        NumericDocValues singleton = context.reader().getNumericDocValues(this.fieldName);
        if (singleton != null) {
            return new SingletonInts(singleton);
        }
        return new BlockLoader.ConstantNullsReader();
    }

    public static class SingletonInts
    extends BlockDocValuesReader
    implements BlockDocValuesReader.NumericDocValuesAccessor {
        private final NumericDocValues numericDocValues;

        SingletonInts(NumericDocValues numericDocValues) {
            this.numericDocValues = numericDocValues;
        }

        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered) throws IOException {
            BlockLoader.OptionalColumnAtATimeReader direct;
            BlockLoader.Block result;
            NumericDocValues numericDocValues = this.numericDocValues;
            if (numericDocValues instanceof BlockLoader.OptionalColumnAtATimeReader && (result = (direct = (BlockLoader.OptionalColumnAtATimeReader)numericDocValues).tryRead(factory, docs, offset, nullsFiltered, null, true)) != null) {
                return result;
            }
            try (BlockLoader.IntBuilder builder = factory.intsFromDocValues(docs.count() - offset);){
                for (int i = offset; i < docs.count(); ++i) {
                    int doc = docs.get(i);
                    if (this.numericDocValues.advanceExact(doc)) {
                        builder.appendInt(Math.toIntExact(this.numericDocValues.longValue()));
                        continue;
                    }
                    builder.appendNull();
                }
                BlockLoader.Block block = builder.build();
                return block;
            }
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            BlockLoader.IntBuilder blockBuilder = (BlockLoader.IntBuilder)builder;
            if (this.numericDocValues.advanceExact(docId)) {
                blockBuilder.appendInt(Math.toIntExact(this.numericDocValues.longValue()));
            } else {
                blockBuilder.appendNull();
            }
        }

        @Override
        public int docId() {
            return this.numericDocValues.docID();
        }

        @Override
        public String toString() {
            return "BlockDocValuesReader.SingletonInts";
        }

        @Override
        public NumericDocValues numericDocValues() {
            return this.numericDocValues;
        }
    }

    public static class Ints
    extends BlockDocValuesReader {
        private final SortedNumericDocValues numericDocValues;

        Ints(SortedNumericDocValues numericDocValues) {
            this.numericDocValues = numericDocValues;
        }

        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered) throws IOException {
            try (BlockLoader.IntBuilder builder = factory.intsFromDocValues(docs.count() - offset);){
                for (int i = offset; i < docs.count(); ++i) {
                    int doc = docs.get(i);
                    this.read(doc, builder);
                }
                BlockLoader.Block block = builder.build();
                return block;
            }
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            this.read(docId, (BlockLoader.IntBuilder)builder);
        }

        private void read(int doc, BlockLoader.IntBuilder builder) throws IOException {
            if (!this.numericDocValues.advanceExact(doc)) {
                builder.appendNull();
                return;
            }
            int count = this.numericDocValues.docValueCount();
            if (count == 1) {
                builder.appendInt(Math.toIntExact(this.numericDocValues.nextValue()));
                return;
            }
            builder.beginPositionEntry();
            for (int v = 0; v < count; ++v) {
                builder.appendInt(Math.toIntExact(this.numericDocValues.nextValue()));
            }
            builder.endPositionEntry();
        }

        @Override
        public int docId() {
            return this.numericDocValues.docID();
        }

        @Override
        public String toString() {
            return "BlockDocValuesReader.Ints";
        }
    }
}

