/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.blockloader.docvalues;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.blockloader.docvalues.BlockDocValuesReader;

public class DoublesBlockLoader
extends BlockDocValuesReader.DocValuesBlockLoader {
    private final String fieldName;
    private final BlockDocValuesReader.ToDouble toDouble;

    public DoublesBlockLoader(String fieldName, BlockDocValuesReader.ToDouble toDouble) {
        this.fieldName = fieldName;
        this.toDouble = toDouble;
    }

    @Override
    public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
        return factory.doubles(expectedCount);
    }

    @Override
    public BlockLoader.AllReader reader(LeafReaderContext context) throws IOException {
        SortedNumericDocValues docValues = context.reader().getSortedNumericDocValues(this.fieldName);
        if (docValues != null) {
            NumericDocValues singleton = DocValues.unwrapSingleton((SortedNumericDocValues)docValues);
            if (singleton != null) {
                return new SingletonDoubles(singleton, this.toDouble);
            }
            return new Doubles(docValues, this.toDouble);
        }
        NumericDocValues singleton = context.reader().getNumericDocValues(this.fieldName);
        if (singleton != null) {
            return new SingletonDoubles(singleton, this.toDouble);
        }
        return new BlockLoader.ConstantNullsReader();
    }

    public static class SingletonDoubles
    extends BlockDocValuesReader
    implements BlockDocValuesReader.NumericDocValuesAccessor {
        private final NumericDocValues docValues;
        private final BlockDocValuesReader.ToDouble toDouble;

        SingletonDoubles(NumericDocValues docValues, BlockDocValuesReader.ToDouble toDouble) {
            this.docValues = docValues;
            this.toDouble = toDouble;
        }

        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered) throws IOException {
            BlockLoader.OptionalColumnAtATimeReader direct;
            BlockLoader.Block result;
            NumericDocValues numericDocValues = this.docValues;
            if (numericDocValues instanceof BlockLoader.OptionalColumnAtATimeReader && (result = (direct = (BlockLoader.OptionalColumnAtATimeReader)numericDocValues).tryRead(factory, docs, offset, nullsFiltered, this.toDouble, false)) != null) {
                return result;
            }
            try (BlockLoader.DoubleBuilder builder = factory.doublesFromDocValues(docs.count() - offset);){
                for (int i = offset; i < docs.count(); ++i) {
                    int doc = docs.get(i);
                    if (this.docValues.advanceExact(doc)) {
                        builder.appendDouble(this.toDouble.convert(this.docValues.longValue()));
                        continue;
                    }
                    builder.appendNull();
                }
                BlockLoader.Block block = builder.build();
                return block;
            }
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            BlockLoader.DoubleBuilder blockBuilder = (BlockLoader.DoubleBuilder)builder;
            if (this.docValues.advanceExact(docId)) {
                blockBuilder.appendDouble(this.toDouble.convert(this.docValues.longValue()));
            } else {
                blockBuilder.appendNull();
            }
        }

        @Override
        public int docId() {
            return this.docValues.docID();
        }

        @Override
        public String toString() {
            return "BlockDocValuesReader.SingletonDoubles";
        }

        @Override
        public NumericDocValues numericDocValues() {
            return this.docValues;
        }
    }

    public static class Doubles
    extends BlockDocValuesReader {
        private final SortedNumericDocValues docValues;
        private final BlockDocValuesReader.ToDouble toDouble;

        Doubles(SortedNumericDocValues docValues, BlockDocValuesReader.ToDouble toDouble) {
            this.docValues = docValues;
            this.toDouble = toDouble;
        }

        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered) throws IOException {
            try (BlockLoader.DoubleBuilder builder = factory.doublesFromDocValues(docs.count() - offset);){
                for (int i = offset; i < docs.count(); ++i) {
                    int doc = docs.get(i);
                    this.read(doc, builder);
                }
                BlockLoader.Block block = builder.build();
                return block;
            }
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            this.read(docId, (BlockLoader.DoubleBuilder)builder);
        }

        private void read(int doc, BlockLoader.DoubleBuilder builder) throws IOException {
            if (!this.docValues.advanceExact(doc)) {
                builder.appendNull();
                return;
            }
            int count = this.docValues.docValueCount();
            if (count == 1) {
                builder.appendDouble(this.toDouble.convert(this.docValues.nextValue()));
                return;
            }
            builder.beginPositionEntry();
            for (int v = 0; v < count; ++v) {
                builder.appendDouble(this.toDouble.convert(this.docValues.nextValue()));
            }
            builder.endPositionEntry();
        }

        @Override
        public int docId() {
            return this.docValues.docID();
        }

        @Override
        public String toString() {
            return "BlockDocValuesReader.Doubles";
        }
    }
}

