/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.blockloader.docvalues;

import java.io.IOException;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.blockloader.docvalues.BlockDocValuesReader;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;

public class DenseVectorBlockLoader
extends BlockDocValuesReader.DocValuesBlockLoader {
    private final String fieldName;
    private final int dimensions;
    private final DenseVectorFieldMapper.DenseVectorFieldType fieldType;

    public DenseVectorBlockLoader(String fieldName, int dimensions, DenseVectorFieldMapper.DenseVectorFieldType fieldType) {
        this.fieldName = fieldName;
        this.dimensions = dimensions;
        this.fieldType = fieldType;
    }

    @Override
    public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
        return factory.denseVectors(expectedCount, this.dimensions);
    }

    @Override
    public BlockLoader.AllReader reader(LeafReaderContext context) throws IOException {
        switch (this.fieldType.getElementType()) {
            case FLOAT: {
                FloatVectorValues floatVectorValues = context.reader().getFloatVectorValues(this.fieldName);
                if (floatVectorValues == null) break;
                if (this.fieldType.isNormalized()) {
                    NumericDocValues magnitudeDocValues = context.reader().getNumericDocValues(this.fieldType.name() + "._magnitude");
                    return new FloatDenseVectorNormalizedValuesBlockReader(floatVectorValues, this.dimensions, magnitudeDocValues);
                }
                return new FloatDenseVectorValuesBlockReader(floatVectorValues, this.dimensions);
            }
            case BYTE: {
                ByteVectorValues byteVectorValues = context.reader().getByteVectorValues(this.fieldName);
                if (byteVectorValues == null) break;
                return new ByteDenseVectorValuesBlockReader(byteVectorValues, this.dimensions);
            }
            case BIT: {
                ByteVectorValues byteVectorValues = context.reader().getByteVectorValues(this.fieldName);
                if (byteVectorValues == null) break;
                return new BitDenseVectorValuesBlockReader(byteVectorValues, this.dimensions);
            }
        }
        return new BlockLoader.ConstantNullsReader();
    }

    private static class FloatDenseVectorNormalizedValuesBlockReader
    extends DenseVectorValuesBlockReader<FloatVectorValues> {
        private final NumericDocValues magnitudeDocValues;

        FloatDenseVectorNormalizedValuesBlockReader(FloatVectorValues floatVectorValues, int dimensions, NumericDocValues magnitudeDocValues) {
            super(floatVectorValues, dimensions);
            this.magnitudeDocValues = magnitudeDocValues;
        }

        @Override
        protected void appendDoc(BlockLoader.FloatBuilder builder) throws IOException {
            float[] floats;
            float magnitude = 1.0f;
            if (this.magnitudeDocValues != null && this.magnitudeDocValues.advanceExact(this.iterator.docID())) {
                magnitude = Float.intBitsToFloat((int)this.magnitudeDocValues.longValue());
            }
            for (float aFloat : floats = ((FloatVectorValues)this.vectorValues).vectorValue(this.iterator.index())) {
                builder.appendFloat(aFloat * magnitude);
            }
        }

        @Override
        public String toString() {
            return "BlockDocValuesReader.FloatDenseVectorNormalizedValuesBlockReader";
        }
    }

    private static class FloatDenseVectorValuesBlockReader
    extends DenseVectorValuesBlockReader<FloatVectorValues> {
        FloatDenseVectorValuesBlockReader(FloatVectorValues floatVectorValues, int dimensions) {
            super(floatVectorValues, dimensions);
        }

        @Override
        protected void appendDoc(BlockLoader.FloatBuilder builder) throws IOException {
            float[] floats;
            for (float aFloat : floats = ((FloatVectorValues)this.vectorValues).vectorValue(this.iterator.index())) {
                builder.appendFloat(aFloat);
            }
        }

        @Override
        public String toString() {
            return "BlockDocValuesReader.FloatDenseVectorValuesBlockReader";
        }
    }

    private static class ByteDenseVectorValuesBlockReader
    extends DenseVectorValuesBlockReader<ByteVectorValues> {
        ByteDenseVectorValuesBlockReader(ByteVectorValues floatVectorValues, int dimensions) {
            super(floatVectorValues, dimensions);
        }

        @Override
        protected void appendDoc(BlockLoader.FloatBuilder builder) throws IOException {
            byte[] bytes;
            for (byte aFloat : bytes = ((ByteVectorValues)this.vectorValues).vectorValue(this.iterator.index())) {
                builder.appendFloat(aFloat);
            }
        }

        @Override
        public String toString() {
            return "BlockDocValuesReader.ByteDenseVectorValuesBlockReader";
        }
    }

    private static class BitDenseVectorValuesBlockReader
    extends ByteDenseVectorValuesBlockReader {
        BitDenseVectorValuesBlockReader(ByteVectorValues floatVectorValues, int dimensions) {
            super(floatVectorValues, dimensions);
        }

        @Override
        protected void assertDimensions() {
            assert (((ByteVectorValues)this.vectorValues).dimension() * 8 == this.dimensions) : "unexpected dimensions for vector value; expected " + this.dimensions + " but got " + ((ByteVectorValues)this.vectorValues).dimension() * 8;
        }

        @Override
        public String toString() {
            return "BlockDocValuesReader.BitDenseVectorValuesBlockReader";
        }
    }

    private static abstract class DenseVectorValuesBlockReader<T extends KnnVectorValues>
    extends BlockDocValuesReader {
        protected final T vectorValues;
        protected final KnnVectorValues.DocIndexIterator iterator;
        protected final int dimensions;

        DenseVectorValuesBlockReader(T vectorValues, int dimensions) {
            this.vectorValues = vectorValues;
            this.iterator = vectorValues.iterator();
            this.dimensions = dimensions;
        }

        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered) throws IOException {
            try (BlockLoader.FloatBuilder builder = factory.denseVectors(docs.count() - offset, this.dimensions);){
                for (int i = offset; i < docs.count(); ++i) {
                    this.read(docs.get(i), builder);
                }
                BlockLoader.Block block = builder.build();
                return block;
            }
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            this.read(docId, (BlockLoader.FloatBuilder)builder);
        }

        private void read(int doc, BlockLoader.FloatBuilder builder) throws IOException {
            this.assertDimensions();
            if (this.iterator.docID() > doc) {
                builder.appendNull();
            } else if (this.iterator.docID() == doc || this.iterator.advance(doc) == doc) {
                builder.beginPositionEntry();
                this.appendDoc(builder);
                builder.endPositionEntry();
            } else {
                builder.appendNull();
            }
        }

        protected abstract void appendDoc(BlockLoader.FloatBuilder var1) throws IOException;

        @Override
        public int docId() {
            return this.iterator.docID();
        }

        protected void assertDimensions() {
            assert (this.vectorValues.dimension() == this.dimensions) : "unexpected dimensions for vector value; expected " + this.dimensions + " but got " + this.vectorValues.dimension();
        }
    }
}

