/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Map;
import org.apache.lucene.queries.intervals.IntervalsSource;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.query.SearchExecutionContext;

public abstract class TextFamilyFieldType
extends StringFieldType {
    private final boolean isSyntheticSourceEnabled;
    private final boolean isWithinMultiField;

    public TextFamilyFieldType(String name, boolean isIndexed, boolean isStored, boolean hasDocValues, TextSearchInfo textSearchInfo, Map<String, String> meta, boolean isSyntheticSourceEnabled, boolean isWithinMultiField) {
        super(name, isIndexed, isStored, hasDocValues, textSearchInfo, meta);
        this.isSyntheticSourceEnabled = isSyntheticSourceEnabled;
        this.isWithinMultiField = isWithinMultiField;
    }

    public boolean isSyntheticSourceEnabled() {
        return this.isSyntheticSourceEnabled;
    }

    public boolean isWithinMultiField() {
        return this.isWithinMultiField;
    }

    public String syntheticSourceFallbackFieldName() {
        return this.name() + "._original";
    }

    public IntervalsSource termIntervals(BytesRef term, SearchExecutionContext context) {
        throw new IllegalArgumentException("Can only use interval queries on text fields - not on [" + this.name() + "] which is of type [" + this.typeName() + "]");
    }

    public IntervalsSource prefixIntervals(BytesRef prefix, SearchExecutionContext context) {
        throw new IllegalArgumentException("Can only use interval queries on text fields - not on [" + this.name() + "] which is of type [" + this.typeName() + "]");
    }

    public IntervalsSource fuzzyIntervals(String term, int maxDistance, int prefixLength, boolean transpositions, SearchExecutionContext context) {
        throw new IllegalArgumentException("Can only use interval queries on text fields - not on [" + this.name() + "] which is of type [" + this.typeName() + "]");
    }

    public IntervalsSource wildcardIntervals(BytesRef pattern, SearchExecutionContext context) {
        throw new IllegalArgumentException("Can only use interval queries on text fields - not on [" + this.name() + "] which is of type [" + this.typeName() + "]");
    }

    public IntervalsSource regexpIntervals(BytesRef pattern, SearchExecutionContext context) {
        throw new IllegalArgumentException("Can only use interval queries on text fields - not on [" + this.name() + "] which is of type [" + this.typeName() + "]");
    }

    public IntervalsSource rangeIntervals(BytesRef lowerTerm, BytesRef upperTerm, boolean includeLower, boolean includeUpper, SearchExecutionContext context) {
        throw new IllegalArgumentException("Can only use interval queries on text fields - not on [" + this.name() + "] which is of type [" + this.typeName() + "]");
    }
}

