/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.concurrent.atomic.AtomicBoolean;

enum IntervalThrottler {
    DOCUMENT_PARSING_FAILURE(60L);

    static final int MILLISECONDS_IN_SECOND = 1000;
    private final Acceptor acceptor;

    private IntervalThrottler(long intervalSeconds) {
        this.acceptor = new Acceptor(intervalSeconds * 1000L);
    }

    boolean accept() {
        return this.acceptor.accept();
    }

    static class Acceptor {
        private final long intervalMillis;
        private final AtomicBoolean lastAcceptedGuard = new AtomicBoolean(false);
        private volatile long lastAcceptedTimeMillis = 0L;

        Acceptor(long intervalMillis) {
            this.intervalMillis = intervalMillis;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean accept() {
            long now = System.currentTimeMillis();
            if (now - this.lastAcceptedTimeMillis > this.intervalMillis && this.lastAcceptedGuard.compareAndSet(false, true)) {
                try {
                    if (now - this.lastAcceptedTimeMillis > this.intervalMillis) {
                        this.lastAcceptedTimeMillis = now;
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    this.lastAcceptedGuard.set(false);
                }
            }
            return false;
        }
    }
}

