/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.index.mapper.blockloader.docvalues.BlockDocValuesReader;
import org.elasticsearch.search.fetch.StoredFieldsSpec;
import org.elasticsearch.search.lookup.Source;

public interface BlockLoader {
    public static final BlockLoader CONSTANT_NULLS = new BlockLoader(){

        @Override
        public Builder builder(BlockFactory factory, int expectedCount) {
            return factory.nulls(expectedCount);
        }

        @Override
        public ColumnAtATimeReader columnAtATimeReader(LeafReaderContext context) {
            return new ConstantNullsReader();
        }

        @Override
        public RowStrideReader rowStrideReader(LeafReaderContext context) {
            return new ConstantNullsReader();
        }

        @Override
        public StoredFieldsSpec rowStrideStoredFieldSpec() {
            return StoredFieldsSpec.NO_REQUIREMENTS;
        }

        @Override
        public boolean supportsOrdinals() {
            return false;
        }

        @Override
        public SortedSetDocValues ordinals(LeafReaderContext context) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "ConstantNull";
        }
    };

    public Builder builder(BlockFactory var1, int var2);

    public ColumnAtATimeReader columnAtATimeReader(LeafReaderContext var1) throws IOException;

    public RowStrideReader rowStrideReader(LeafReaderContext var1) throws IOException;

    public StoredFieldsSpec rowStrideStoredFieldSpec();

    public boolean supportsOrdinals();

    public SortedSetDocValues ordinals(LeafReaderContext var1) throws IOException;

    default public Block convert(Block block) {
        return block;
    }

    public static BlockLoader constantBytes(final BytesRef value) {
        return new BlockLoader(){

            @Override
            public Builder builder(BlockFactory factory, int expectedCount) {
                return factory.bytesRefs(expectedCount);
            }

            @Override
            public ColumnAtATimeReader columnAtATimeReader(LeafReaderContext context) {
                return new ColumnAtATimeReader(){

                    @Override
                    public Block read(BlockFactory factory, Docs docs, int offset, boolean nullsFiltered) {
                        return factory.constantBytes(value, docs.count() - offset);
                    }

                    @Override
                    public boolean canReuse(int startingDocID) {
                        return true;
                    }

                    public String toString() {
                        return "constant[" + String.valueOf(value) + "]";
                    }
                };
            }

            @Override
            public RowStrideReader rowStrideReader(LeafReaderContext context) {
                return new RowStrideReader(){

                    @Override
                    public void read(int docId, StoredFields storedFields, Builder builder) {
                        ((BytesRefBuilder)builder).appendBytesRef(value);
                    }

                    @Override
                    public boolean canReuse(int startingDocID) {
                        return true;
                    }

                    public String toString() {
                        return "constant[" + String.valueOf(value) + "]";
                    }
                };
            }

            @Override
            public StoredFieldsSpec rowStrideStoredFieldSpec() {
                return StoredFieldsSpec.NO_REQUIREMENTS;
            }

            @Override
            public boolean supportsOrdinals() {
                return false;
            }

            @Override
            public SortedSetDocValues ordinals(LeafReaderContext context) {
                throw new UnsupportedOperationException();
            }

            public String toString() {
                return "ConstantBytes[" + String.valueOf(value) + "]";
            }
        };
    }

    public static interface AggregateMetricDoubleBuilder
    extends Builder {
        public DoubleBuilder min();

        public DoubleBuilder max();

        public DoubleBuilder sum();

        public IntBuilder count();
    }

    public static interface SortedSetOrdinalsBuilder
    extends Builder {
        public SortedSetOrdinalsBuilder appendOrd(int var1);
    }

    public static interface SingletonOrdinalsBuilder
    extends Builder {
        public SingletonOrdinalsBuilder appendOrd(int var1);

        public SingletonOrdinalsBuilder appendOrds(int[] var1, int var2, int var3, int var4, int var5);
    }

    public static interface LongBuilder
    extends Builder {
        public LongBuilder appendLong(long var1);
    }

    public static interface SingletonIntBuilder
    extends Builder {
        public SingletonIntBuilder appendLongs(long[] var1, int var2, int var3);
    }

    public static interface SingletonDoubleBuilder
    extends Builder {
        public SingletonDoubleBuilder appendLongs(BlockDocValuesReader.ToDouble var1, long[] var2, int var3, int var4);
    }

    public static interface SingletonLongBuilder
    extends Builder {
        public SingletonLongBuilder appendLong(long var1);

        public SingletonLongBuilder appendLongs(long[] var1, int var2, int var3);
    }

    public static interface IntBuilder
    extends Builder {
        public IntBuilder appendInt(int var1);
    }

    public static interface DoubleBuilder
    extends Builder {
        public DoubleBuilder appendDouble(double var1);
    }

    public static interface FloatBuilder
    extends Builder {
        public FloatBuilder appendFloat(float var1);
    }

    public static interface BytesRefBuilder
    extends Builder {
        public BytesRefBuilder appendBytesRef(BytesRef var1);
    }

    public static interface BooleanBuilder
    extends Builder {
        public BooleanBuilder appendBoolean(boolean var1);
    }

    public static interface Builder
    extends Releasable {
        public Block build();

        public Builder appendNull();

        public Builder beginPositionEntry();

        public Builder endPositionEntry();
    }

    public static interface Block
    extends Releasable {
    }

    public static interface BlockFactory {
        public BooleanBuilder booleansFromDocValues(int var1);

        public BooleanBuilder booleans(int var1);

        public BytesRefBuilder bytesRefsFromDocValues(int var1);

        public BytesRefBuilder bytesRefs(int var1);

        public DoubleBuilder doublesFromDocValues(int var1);

        public DoubleBuilder doubles(int var1);

        public FloatBuilder denseVectors(int var1, int var2);

        public IntBuilder intsFromDocValues(int var1);

        public IntBuilder ints(int var1);

        public LongBuilder longsFromDocValues(int var1);

        public LongBuilder longs(int var1);

        public SingletonLongBuilder singletonLongs(int var1);

        public SingletonIntBuilder singletonInts(int var1);

        public SingletonDoubleBuilder singletonDoubles(int var1);

        public Builder nulls(int var1);

        public Block constantNulls(int var1);

        public Block constantBytes(BytesRef var1, int var2);

        public SingletonOrdinalsBuilder singletonOrdinalsBuilder(SortedDocValues var1, int var2, boolean var3);

        public SortedSetOrdinalsBuilder sortedSetOrdinalsBuilder(SortedSetDocValues var1, int var2);

        public AggregateMetricDoubleBuilder aggregateMetricDoubleBuilder(int var1);
    }

    public static interface Docs {
        public int count();

        public int get(int var1);
    }

    public static abstract class Delegating
    implements BlockLoader {
        protected final BlockLoader delegate;

        protected Delegating(BlockLoader delegate) {
            this.delegate = delegate;
        }

        @Override
        public Builder builder(BlockFactory factory, int expectedCount) {
            return this.delegate.builder(factory, expectedCount);
        }

        @Override
        public ColumnAtATimeReader columnAtATimeReader(LeafReaderContext context) throws IOException {
            final ColumnAtATimeReader reader = this.delegate.columnAtATimeReader(context);
            if (reader == null) {
                return null;
            }
            return new ColumnAtATimeReader(){

                @Override
                public Block read(BlockFactory factory, Docs docs, int offset, boolean nullsFiltered) throws IOException {
                    return reader.read(factory, docs, offset, nullsFiltered);
                }

                @Override
                public boolean canReuse(int startingDocID) {
                    return reader.canReuse(startingDocID);
                }

                public String toString() {
                    return "Delegating[to=" + this.delegatingTo() + ", impl=" + String.valueOf(reader) + "]";
                }
            };
        }

        @Override
        public RowStrideReader rowStrideReader(LeafReaderContext context) throws IOException {
            final RowStrideReader reader = this.delegate.rowStrideReader(context);
            if (reader == null) {
                return null;
            }
            return new RowStrideReader(){

                @Override
                public void read(int docId, StoredFields storedFields, Builder builder) throws IOException {
                    reader.read(docId, storedFields, builder);
                }

                @Override
                public boolean canReuse(int startingDocID) {
                    return reader.canReuse(startingDocID);
                }

                public String toString() {
                    return "Delegating[to=" + this.delegatingTo() + ", impl=" + String.valueOf(reader) + "]";
                }
            };
        }

        @Override
        public StoredFieldsSpec rowStrideStoredFieldSpec() {
            return this.delegate.rowStrideStoredFieldSpec();
        }

        @Override
        public boolean supportsOrdinals() {
            return this.delegate.supportsOrdinals();
        }

        @Override
        public SortedSetDocValues ordinals(LeafReaderContext context) throws IOException {
            return this.delegate.ordinals(context);
        }

        protected abstract String delegatingTo();

        public final String toString() {
            return "Delegating[to=" + this.delegatingTo() + ", impl=" + String.valueOf(this.delegate) + "]";
        }
    }

    public static class ConstantNullsReader
    implements AllReader {
        @Override
        public Block read(BlockFactory factory, Docs docs, int offset, boolean nullsFiltered) throws IOException {
            return factory.constantNulls(docs.count() - offset);
        }

        @Override
        public void read(int docId, StoredFields storedFields, Builder builder) throws IOException {
            builder.appendNull();
        }

        @Override
        public boolean canReuse(int startingDocID) {
            return true;
        }

        public String toString() {
            return "constant_nulls";
        }
    }

    public static interface StoredFields {
        public Source source() throws IOException;

        public String id() throws IOException;

        public String routing() throws IOException;

        public Map<String, List<Object>> storedFields() throws IOException;
    }

    public static interface AllReader
    extends ColumnAtATimeReader,
    RowStrideReader {
    }

    public static interface RowStrideReader
    extends Reader {
        public void read(int var1, StoredFields var2, Builder var3) throws IOException;
    }

    public static interface OptionalColumnAtATimeReader {
        @Nullable
        public Block tryRead(BlockFactory var1, Docs var2, int var3, boolean var4, BlockDocValuesReader.ToDouble var5, boolean var6) throws IOException;
    }

    public static interface ColumnAtATimeReader
    extends Reader {
        public Block read(BlockFactory var1, Docs var2, int var3, boolean var4) throws IOException;
    }

    public static interface Reader {
        public boolean canReuse(int var1);
    }
}

