/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import org.elasticsearch.index.fielddata.SortedNumericLongValues;
import org.elasticsearch.script.BooleanFieldScript;

public final class BooleanScriptDocValues
extends SortedNumericLongValues {
    private final BooleanFieldScript script;
    private int cursor;

    BooleanScriptDocValues(BooleanFieldScript script) {
        this.script = script;
    }

    @Override
    public boolean advanceExact(int docId) {
        this.script.runForDoc(docId);
        this.cursor = 0;
        return this.script.trues() > 0 || this.script.falses() > 0;
    }

    @Override
    public long nextValue() {
        return this.cursor++ < this.script.falses() ? 0L : 1L;
    }

    @Override
    public int docValueCount() {
        return this.script.trues() + this.script.falses();
    }
}

