/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors.es93;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.hnsw.FlatVectorsReader;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.AcceptDocs;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.apache.lucene.util.hnsw.RandomVectorScorerSupplier;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.index.codec.vectors.GenericFlatVectorReaders;
import org.elasticsearch.index.codec.vectors.es93.GenericFormatMetaInformation;

class ES93GenericFlatVectorsReader
extends FlatVectorsReader {
    private final FieldInfos fieldInfos;
    private final GenericFlatVectorReaders genericReaders;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ES93GenericFlatVectorsReader(GenericFormatMetaInformation metaInfo, SegmentReadState state, GenericFlatVectorReaders.LoadFlatVectorsReader loadReader) throws IOException {
        block13: {
            super(null);
            this.fieldInfos = state.fieldInfos;
            this.genericReaders = new GenericFlatVectorReaders();
            String metaFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)metaInfo.extension());
            int versionMeta = -1;
            try (ChecksumIndexInput metaIn = state.directory.openChecksumInput(metaFileName);){
                Throwable priorE = null;
                try {
                    versionMeta = CodecUtil.checkIndexHeader((DataInput)metaIn, (String)metaInfo.codecName(), (int)metaInfo.versionStart(), (int)metaInfo.versionCurrent(), (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                    ES93GenericFlatVectorsReader.readFields((IndexInput)metaIn, state.fieldInfos, this.genericReaders, loadReader);
                }
                catch (Throwable exception) {
                    try {
                        priorE = exception;
                        break block13;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        CodecUtil.checkFooter((ChecksumIndexInput)metaIn, (Throwable)priorE);
                    }
                }
                CodecUtil.checkFooter((ChecksumIndexInput)metaIn, (Throwable)priorE);
            }
            catch (Throwable t) {
                IOUtils.closeWhileHandlingException((Closeable)((Object)this));
                throw t;
            }
        }
    }

    private ES93GenericFlatVectorsReader(FieldInfos fieldInfos, GenericFlatVectorReaders genericReaders) {
        super(null);
        this.fieldInfos = fieldInfos;
        this.genericReaders = genericReaders;
    }

    private static void readFields(IndexInput meta, FieldInfos fieldInfos, GenericFlatVectorReaders fieldHelper, GenericFlatVectorReaders.LoadFlatVectorsReader loadReader) throws IOException {
        int fieldNumber = meta.readInt();
        while (fieldNumber != -1) {
            FieldInfo info = fieldInfos.fieldInfo(fieldNumber);
            if (info == null) {
                throw new CorruptIndexException("Invalid field number: " + fieldNumber, (DataInput)meta);
            }
            record FieldEntry(String rawVectorFormatName, boolean useDirectIOReads) implements GenericFlatVectorReaders.Field
            {
            }
            FieldEntry entry = new FieldEntry(meta.readString(), meta.readByte() == 1);
            fieldHelper.loadField(fieldNumber, entry, loadReader);
            fieldNumber = meta.readInt();
        }
    }

    public FlatVectorsScorer getFlatVectorScorer() {
        return new FlatVectorsScorer(this){

            public RandomVectorScorerSupplier getRandomVectorScorerSupplier(VectorSimilarityFunction similarityFunction, KnnVectorValues vectorValues) throws IOException {
                throw new UnsupportedOperationException("Scorer should not be used");
            }

            public RandomVectorScorer getRandomVectorScorer(VectorSimilarityFunction similarityFunction, KnnVectorValues vectorValues, float[] target) throws IOException {
                throw new UnsupportedOperationException("Scorer should not be used");
            }

            public RandomVectorScorer getRandomVectorScorer(VectorSimilarityFunction similarityFunction, KnnVectorValues vectorValues, byte[] target) throws IOException {
                throw new UnsupportedOperationException("Scorer should not be used");
            }
        };
    }

    public FlatVectorsReader getMergeInstance() throws IOException {
        return new ES93GenericFlatVectorsReader(this.fieldInfos, this.genericReaders.getMergeInstance());
    }

    public void finishMerge() throws IOException {
        for (FlatVectorsReader reader : this.genericReaders.allReaders()) {
            reader.finishMerge();
        }
    }

    public void checkIntegrity() throws IOException {
        for (FlatVectorsReader reader : this.genericReaders.allReaders()) {
            reader.checkIntegrity();
        }
    }

    private int findField(String field) {
        FieldInfo info = this.fieldInfos.fieldInfo(field);
        if (info == null) {
            throw new IllegalArgumentException("Could not find field [" + field + "]");
        }
        return info.number;
    }

    public FloatVectorValues getFloatVectorValues(String field) throws IOException {
        return this.genericReaders.getReaderForField(this.findField(field)).getFloatVectorValues(field);
    }

    public ByteVectorValues getByteVectorValues(String field) throws IOException {
        return this.genericReaders.getReaderForField(this.findField(field)).getByteVectorValues(field);
    }

    public RandomVectorScorer getRandomVectorScorer(String field, byte[] target) throws IOException {
        return this.genericReaders.getReaderForField(this.findField(field)).getRandomVectorScorer(field, target);
    }

    public RandomVectorScorer getRandomVectorScorer(String field, float[] target) throws IOException {
        return this.genericReaders.getReaderForField(this.findField(field)).getRandomVectorScorer(field, target);
    }

    public void search(String field, float[] target, KnnCollector knnCollector, AcceptDocs acceptDocs) throws IOException {
        this.genericReaders.getReaderForField(this.findField(field)).search(field, target, knnCollector, acceptDocs);
    }

    public void search(String field, byte[] target, KnnCollector knnCollector, AcceptDocs acceptDocs) throws IOException {
        this.genericReaders.getReaderForField(this.findField(field)).search(field, target, knnCollector, acceptDocs);
    }

    public long ramBytesUsed() {
        return this.genericReaders.allReaders().stream().mapToLong(Accountable::ramBytesUsed).sum();
    }

    public Map<String, Long> getOffHeapByteSize(FieldInfo fieldInfo) {
        return this.genericReaders.getReaderForField(fieldInfo.number).getOffHeapByteSize(fieldInfo);
    }

    public void close() throws IOException {
        IOUtils.close(this.genericReaders.allReaders());
    }
}

