/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public interface ChunkedToXContent {
    public static final ChunkedToXContent EMPTY = params -> Collections.emptyIterator();

    default public Iterator<? extends ToXContent> toXContentChunked(RestApiVersion restApiVersion, ToXContent.Params params) {
        return switch (restApiVersion) {
            default -> throw new MatchException(null, null);
            case RestApiVersion.V_8 -> this.toXContentChunkedV8(params);
            case RestApiVersion.V_9 -> this.toXContentChunked(params);
        };
    }

    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params var1);

    default public Iterator<? extends ToXContent> toXContentChunkedV8(ToXContent.Params params) {
        return this.toXContentChunked(params);
    }

    public static ToXContent wrapAsToXContent(final ChunkedToXContent chunkedToXContent) {
        return new ToXContent(){

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                Iterator<? extends ToXContent> serialization = chunkedToXContent.toXContentChunked(params);
                while (serialization.hasNext()) {
                    serialization.next().toXContent(builder, params);
                }
                return builder;
            }

            public boolean isFragment() {
                return chunkedToXContent.isFragment();
            }
        };
    }

    default public boolean isFragment() {
        return true;
    }
}

