/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Nullable;

public final class ThreadContextTransient<T> {
    private final String key;
    private final Class<T> type;

    private ThreadContextTransient(String key, Class<T> type) {
        this.key = key;
        this.type = type;
    }

    public String getKey() {
        return this.key;
    }

    public boolean exists(ThreadContext threadContext) {
        return threadContext.getTransient(this.key) != null;
    }

    @Nullable
    public T get(ThreadContext threadContext) {
        Object val = threadContext.getTransient(this.key);
        if (val == null) {
            return null;
        }
        if (this.type.isInstance(val)) {
            return this.type.cast(val);
        }
        String message = Strings.format("Found object of type [%s] as transient [%s] in thread-context, but expected it to be [%s]", val.getClass(), this.key, this.type);
        assert (false) : message;
        throw new IllegalStateException(message);
    }

    public T require(ThreadContext threadContext) {
        T value = this.get(threadContext);
        if (value == null) {
            throw new IllegalStateException("Cannot find value for [" + this.key + "] in thread-context");
        }
        return value;
    }

    public void set(ThreadContext threadContext, T value) {
        threadContext.putTransient(this.key, value);
    }

    public boolean setIfEmpty(ThreadContext threadContext, T value) {
        if (!this.exists(threadContext)) {
            this.set(threadContext, value);
            return true;
        }
        return false;
    }

    public static <T> ThreadContextTransient<T> transientValue(String key, Class<T> type) {
        return new ThreadContextTransient<T>(key, type);
    }
}

